/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;

@Internal
final class ShuffleJsonDeserializer
extends StdDeserializer<ExecEdge.Shuffle> {
    private static final long serialVersionUID = 1L;

    ShuffleJsonDeserializer() {
        super(ExecEdge.Shuffle.class);
    }

    public ExecEdge.Shuffle deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        ExecEdge.Shuffle.Type type = ExecEdge.Shuffle.Type.valueOf(jsonNode.get("type").asText().toUpperCase());
        switch (type) {
            case ANY: {
                return ExecEdge.ANY_SHUFFLE;
            }
            case SINGLETON: {
                return ExecEdge.SINGLETON_SHUFFLE;
            }
            case BROADCAST: {
                return ExecEdge.BROADCAST_SHUFFLE;
            }
            case FORWARD: {
                return ExecEdge.FORWARD_SHUFFLE;
            }
            case HASH: {
                JsonNode keysNode = jsonNode.get("keys");
                if (keysNode == null || keysNode.size() == 0) {
                    throw new TableException("Hash shuffle requires non-empty hash keys.");
                }
                int[] keys = new int[keysNode.size()];
                for (int i = 0; i < keysNode.size(); ++i) {
                    keys[i] = keysNode.get(i).asInt();
                }
                return ExecEdge.hashShuffle(keys);
            }
        }
        throw new TableException("Unsupported shuffle type: " + String.valueOf((Object)type));
    }
}

