/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.hive;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil;
import org.apache.flink.table.runtime.script.ScriptTransformIOInfo;

public class LogicalScriptTransform
extends SingleRel {
    private final int[] fieldIndices;
    private final String script;
    private final ScriptTransformIOInfo scriptTransformIOInfo;
    private final RelDataType outputRowType;

    private LogicalScriptTransform(RelOptCluster cluster, RelTraitSet traits, RelNode input, int[] fieldIndices, String script, ScriptTransformIOInfo scriptTransformIOInfo, RelDataType outputRowType) {
        super(cluster, traits, input);
        this.fieldIndices = fieldIndices;
        this.script = script;
        this.scriptTransformIOInfo = scriptTransformIOInfo;
        this.outputRowType = outputRowType;
    }

    public static LogicalScriptTransform create(RelNode input, int[] fieldIndices, String script, ScriptTransformIOInfo scriptTransformIOInfo, RelDataType outputRowType) {
        return new LogicalScriptTransform(input.getCluster(), input.getTraitSet(), input, fieldIndices, script, scriptTransformIOInfo, outputRowType);
    }

    @Override
    public LogicalScriptTransform copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new LogicalScriptTransform(this.getCluster(), traitSet, inputs.get(0), this.fieldIndices, this.script, this.scriptTransformIOInfo, this.outputRowType);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    public String getScript() {
        return this.script;
    }

    public int[] getFieldIndices() {
        return this.fieldIndices;
    }

    public ScriptTransformIOInfo getScriptInputOutSchema() {
        return this.scriptTransformIOInfo;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.outputRowType;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        pw.item("script-inputs", RelExplainUtil.fieldToString(this.fieldIndices, this.input.getRowType())).item("script-outputs", String.join((CharSequence)", ", this.getRowType().getFieldNames())).item("script", this.script).item("script-io-info", this.scriptTransformIOInfo);
        return pw;
    }
}

