/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.common;

import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.flink.table.planner.plan.nodes.exec.spec.VectorSearchSpec;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtil;
import org.apache.flink.table.planner.plan.utils.JoinTypeUtil;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil;
import scala.Enumeration;
import scala.Function5;
import scala.Option;
import scala.collection.immutable.List;

public abstract class CommonPhysicalVectorSearchFunction
extends SingleRel
implements FlinkPhysicalRel {
    protected final TableSourceTable searchTable;
    @Nullable
    protected final RexProgram projectionOnVectorTable;
    protected final VectorSearchSpec vectorSearchSpec;
    protected final RelDataType outputRowType;

    protected CommonPhysicalVectorSearchFunction(RelOptCluster cluster, RelTraitSet traits, RelNode input, RelOptTable searchTable, @Nullable RexProgram projectionOnVectorTable, VectorSearchSpec vectorSearchSpec, RelDataType outputRowType) {
        super(cluster, traits, input);
        this.searchTable = (TableSourceTable)searchTable;
        this.projectionOnVectorTable = projectionOnVectorTable;
        this.vectorSearchSpec = vectorSearchSpec;
        this.outputRowType = outputRowType;
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.outputRowType;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        java.util.List columnToSearch = this.vectorSearchSpec.getSearchColumns().keySet().stream().map(this.searchTable.getRowType().getFieldNames()::get).collect(Collectors.toList());
        java.util.List columnToQuery = this.vectorSearchSpec.getSearchColumns().values().stream().map(param -> FunctionCallUtil.explainFunctionParam(param, this.getInput().getRowType().getFieldNames())).collect(Collectors.toList());
        Integer topK = ((FunctionCallUtil.Constant)this.vectorSearchSpec.getTopK()).literal.getValueAs(Integer.class);
        String leftSelect = String.join((CharSequence)", ", this.getInput().getRowType().getFieldNames());
        String rightSelect = this.projectionOnVectorTable == null ? String.join((CharSequence)", ", this.searchTable.getRowType().getFieldNames()) : RelExplainUtil.selectionToString(this.projectionOnVectorTable, (Function5<RexNode, List<String>, Option<List<RexNode>>, Enumeration.Value, Enumeration.Value, String>)((Function5)this::getExpressionString), RelExplainUtil.preferExpressionFormat(pw), this.convertToExpressionDetail(pw.getDetailLevel()));
        return super.explainTerms(pw).item("table", this.searchTable.contextResolvedTable().getIdentifier().asSummaryString()).item("joinType", JoinTypeUtil.getFlinkJoinType(this.vectorSearchSpec.getJoinType())).item("columnToSearch", String.join((CharSequence)", ", columnToSearch)).item("columnToQuery", String.join((CharSequence)", ", columnToQuery)).item("topK", topK).itemIf("config", this.vectorSearchSpec.getRuntimeConfig(), this.vectorSearchSpec.getRuntimeConfig() != null).item("select", String.join((CharSequence)", ", leftSelect, rightSelect, "score"));
    }
}

