/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.stream;

import java.util.List;
import java.util.Optional;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecAsyncCorrelate;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableFunctionScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalCorrelateBase;
import org.apache.flink.table.planner.plan.utils.JoinTypeUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;

public class StreamPhysicalAsyncCorrelate
extends StreamPhysicalCorrelateBase {
    private final RelOptCluster cluster;
    private final FlinkLogicalTableFunctionScan scan;
    private final Optional<List<RexNode>> projections;
    private final Optional<RexNode> condition;
    private final JoinRelType joinType;

    public StreamPhysicalAsyncCorrelate(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputRel, FlinkLogicalTableFunctionScan scan, Optional<List<RexNode>> projections, Optional<RexNode> condition, RelDataType outputRowType, JoinRelType joinType) {
        super(cluster, traitSet, inputRel, scan, JavaScalaConversionUtil.toScala(condition), outputRowType, joinType);
        this.cluster = cluster;
        this.scan = scan;
        this.projections = projections;
        this.condition = condition;
        this.joinType = joinType;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, RelNode newChild, RelDataType outputType) {
        return new StreamPhysicalAsyncCorrelate(this.cluster, traitSet, newChild, this.scan, this.projections, this.condition, outputType, this.joinType);
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        if (this.projections.isPresent() || this.condition.isPresent()) {
            throw new TableException("Currently Async correlate does not support projections or conditions.");
        }
        return new StreamExecAsyncCorrelate((ReadableConfig)ShortcutUtils.unwrapTableConfig(this), JoinTypeUtil.getFlinkJoinType(this.joinType), (RexCall)this.scan.getCall(), InputProperty.DEFAULT, FlinkTypeFactory.toLogicalRowType(this.getRowType()), this.getRelDetailedDescription());
    }
}

