/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalSnapshot;
import org.apache.calcite.rel.rules.MultiJoin;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.hint.StateTtlHint;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableJoinToMultiJoinRule;
import org.apache.flink.table.planner.plan.utils.IntervalJoinUtil;
import org.apache.flink.table.planner.plan.utils.MultiJoinUtil;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.AttributeBasedJoinKeyExtractor;
import org.apache.flink.table.utils.NoCommonJoinKeyException;
import org.immutables.value.Value;

@Value.Enclosing
public class JoinToMultiJoinRule
extends RelRule<Config>
implements TransformationRule {
    public static final JoinToMultiJoinRule INSTANCE = Config.DEFAULT.toRule();

    public JoinToMultiJoinRule(Config config) {
        super(config);
    }

    @Deprecated
    public JoinToMultiJoinRule(Class<? extends Join> clazz) {
        this(Config.DEFAULT.withOperandFor(clazz));
    }

    @Deprecated
    public JoinToMultiJoinRule(Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(joinClass));
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Join origJoin = (Join)call.rel(0);
        if (origJoin.getJoinType() != JoinRelType.INNER && origJoin.getJoinType() != JoinRelType.LEFT) {
            return false;
        }
        if (this.isIntervalJoin(origJoin) || this.isTemporalJoin(call)) {
            return false;
        }
        return origJoin.getJoinType().projectsRight();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join origJoin = (Join)call.rel(0);
        Object left = call.rel(1);
        Object right = call.rel(2);
        ArrayList<Boolean> inputNullGenFieldList = new ArrayList<Boolean>();
        this.buildInputNullGenFieldList((RelNode)left, (RelNode)right, origJoin.getJoinType(), (List<Boolean>)inputNullGenFieldList);
        ArrayList<ImmutableBitSet> projFieldsList = new ArrayList<ImmutableBitSet>();
        ArrayList<int[]> joinFieldRefCountsList = new ArrayList<int[]>();
        List<RelNode> newInputs = this.combineInputs(origJoin, (RelNode)left, (RelNode)right, (List<ImmutableBitSet>)projFieldsList, (List<int[]>)joinFieldRefCountsList);
        ArrayList<Pair<JoinRelType, RexNode>> joinSpecs = new ArrayList<Pair<JoinRelType, RexNode>>();
        this.combineJoinInfo(origJoin, (RelNode)left, (List<Pair<JoinRelType, RexNode>>)joinSpecs);
        List<RexNode> newJoinFilters = this.combineJoinFilters(origJoin, (RelNode)left, (RelNode)right, (List<Boolean>)inputNullGenFieldList);
        Map<Integer, ImmutableIntList> newJoinFieldRefCountsMap = this.addOnJoinFieldRefCounts(newInputs, origJoin.getRowType().getFieldCount(), origJoin.getCondition(), joinFieldRefCountsList);
        List<RexNode> newPostJoinFilters = this.combinePostJoinFilters(origJoin, (RelNode)left, (RelNode)right);
        RexBuilder rexBuilder = origJoin.getCluster().getRexBuilder();
        RelHint.Builder builder = RelHint.builder(StateTtlHint.STATE_TTL.getHintName());
        this.handleStateTtlHintsForInput(builder, (RelNode)left, origJoin, "LEFT");
        this.handleStateTtlHintsForInput(builder, (RelNode)right, origJoin, "RIGHT");
        MultiJoin multiJoin = new MultiJoin(origJoin.getCluster(), List.of(builder.build()), newInputs, RexUtil.composeConjunction(rexBuilder, newJoinFilters), origJoin.getRowType(), origJoin.getJoinType() == JoinRelType.FULL, Pair.right(joinSpecs), Pair.left(joinSpecs), projFieldsList, ImmutableMap.copyOf(newJoinFieldRefCountsMap), RexUtil.composeConjunction(rexBuilder, newPostJoinFilters, true));
        call.transformTo(multiJoin);
    }

    private void buildInputNullGenFieldList(RelNode left, RelNode right, JoinRelType joinType, List<Boolean> isNullGenFieldList) {
        if (joinType == JoinRelType.INNER) {
            this.buildNullGenFieldList(left, isNullGenFieldList);
            this.buildNullGenFieldList(right, isNullGenFieldList);
        } else if (joinType == JoinRelType.LEFT) {
            this.buildNullGenFieldList(left, isNullGenFieldList);
            for (int i = 0; i < right.getRowType().getFieldCount(); ++i) {
                isNullGenFieldList.add(true);
            }
        } else {
            throw new TableException("This is a bug. Now, join to multi join rule only support Full outer join, Inner join and Left/Right join.");
        }
    }

    private void buildNullGenFieldList(RelNode rel, List<Boolean> isNullGenFieldList) {
        MultiJoin multiJoin;
        MultiJoin multiJoin2 = multiJoin = rel instanceof MultiJoin ? (MultiJoin)rel : null;
        if (multiJoin == null) {
            for (int i = 0; i < rel.getRowType().getFieldCount(); ++i) {
                isNullGenFieldList.add(false);
            }
        } else {
            List<RelNode> inputs = multiJoin.getInputs();
            List<JoinRelType> joinTypes = multiJoin.getJoinTypes();
            for (int i = 0; i < inputs.size() - 1; ++i) {
                if (joinTypes.get(i) == JoinRelType.RIGHT) {
                    this.buildInputNullGenFieldList(inputs.get(i), inputs.get(i + 1), joinTypes.get(i), isNullGenFieldList);
                    continue;
                }
                this.buildInputNullGenFieldList(inputs.get(i), inputs.get(i + 1), joinTypes.get(i + 1), isNullGenFieldList);
            }
        }
    }

    private List<RelNode> combineInputs(Join join, RelNode left, RelNode right, List<ImmutableBitSet> projFieldsList, List<int[]> joinFieldRefCountsList) {
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        this.combineIfCan(join, left, newInputs, projFieldsList, joinFieldRefCountsList);
        this.combineIfCan(join, right, newInputs, projFieldsList, joinFieldRefCountsList);
        return newInputs;
    }

    private void combineIfCan(Join join, RelNode relNode, List<RelNode> newInputs, List<ImmutableBitSet> projFieldsList, List<int[]> joinFieldRefCountsList) {
        if (this.canCombine(relNode, join)) {
            MultiJoin multiJoin = (MultiJoin)relNode;
            for (int i = 0; i < multiJoin.getInputs().size(); ++i) {
                newInputs.add(multiJoin.getInput(i));
                projFieldsList.add(multiJoin.getProjFields().get(i));
                joinFieldRefCountsList.add(multiJoin.getJoinFieldRefCountsMap().get(i).toIntArray());
            }
        } else {
            newInputs.add(relNode);
            projFieldsList.add(null);
            joinFieldRefCountsList.add(new int[relNode.getRowType().getFieldCount()]);
        }
    }

    private void combineJoinInfo(Join joinRel, RelNode left, List<Pair<JoinRelType, RexNode>> joinSpecs) {
        JoinRelType joinType = joinRel.getJoinType();
        RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
        boolean leftCombined = this.canCombine(left, joinRel);
        switch (joinType) {
            case LEFT: 
            case INNER: {
                if (leftCombined) {
                    this.copyJoinInfo((MultiJoin)left, joinSpecs);
                } else {
                    joinSpecs.add(Pair.of(JoinRelType.INNER, rexBuilder.makeLiteral(true)));
                }
                joinSpecs.add(Pair.of(joinType, joinRel.getCondition()));
                break;
            }
            default: {
                throw new TableException("This is a bug. This rule only supports left and inner joins");
            }
        }
    }

    private void copyJoinInfo(MultiJoin multiJoin, List<Pair<JoinRelType, RexNode>> destJoinSpecs) {
        List<Pair<JoinRelType, RexNode>> srcJoinSpecs = Pair.zip(multiJoin.getJoinTypes(), multiJoin.getOuterJoinConditions());
        destJoinSpecs.addAll(srcJoinSpecs);
    }

    private List<RexNode> combineJoinFilters(Join join, RelNode left, RelNode right, List<Boolean> inputNullGenFieldList) {
        JoinRelType joinType = join.getJoinType();
        JoinInfo joinInfo = join.analyzeCondition();
        ImmutableIntList leftKeys = joinInfo.leftKeys;
        if (joinType == JoinRelType.RIGHT) {
            throw new TableException("This is a bug. This rule only supports left and inner joins");
        }
        ArrayList<RexNode> filters = new ArrayList<RexNode>();
        if (joinType != JoinRelType.LEFT) {
            filters.add(join.getCondition());
        }
        if (this.canCombine(left, join)) {
            filters.add(((MultiJoin)left).getJoinFilter());
        }
        return filters;
    }

    private boolean canCombine(RelNode input, Join origJoin) {
        if (input instanceof MultiJoin) {
            MultiJoin join = (MultiJoin)input;
            if (join.isFullOuterJoin()) {
                return false;
            }
            return this.haveCommonJoinKey(origJoin, join);
        }
        return false;
    }

    private boolean haveCommonJoinKey(Join origJoin, MultiJoin otherJoin) {
        List<RelNode> combinedJoinInputs = Stream.concat(otherJoin.getInputs().stream(), Stream.of(origJoin.getRight())).collect(Collectors.toUnmodifiableList());
        List combinedInputTypes = combinedJoinInputs.stream().map(i -> FlinkTypeFactory.toLogicalRowType(i.getRowType())).collect(Collectors.toUnmodifiableList());
        List combinedJoinConditions = Stream.concat(otherJoin.getOuterJoinConditions().stream(), List.of(origJoin.getCondition()).stream()).collect(Collectors.toUnmodifiableList());
        Map<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>> joinAttributeMap = MultiJoinUtil.createJoinAttributeMap(combinedJoinInputs, combinedJoinConditions);
        boolean haveCommonJoinKey = false;
        try {
            AttributeBasedJoinKeyExtractor keyExtractor = new AttributeBasedJoinKeyExtractor(joinAttributeMap, combinedInputTypes);
            haveCommonJoinKey = keyExtractor.getCommonJoinKeyIndices(0).length > 0;
        }
        catch (NoCommonJoinKeyException noCommonJoinKeyException) {
            // empty catch block
        }
        return haveCommonJoinKey;
    }

    private RexNode shiftRightFilter(Join joinRel, RelNode left, MultiJoin right, RexNode rightFilter) {
        if (rightFilter == null) {
            return null;
        }
        int nFieldsOnLeft = left.getRowType().getFieldList().size();
        int nFieldsOnRight = right.getRowType().getFieldList().size();
        int[] adjustments = new int[nFieldsOnRight];
        Arrays.fill(adjustments, nFieldsOnLeft);
        rightFilter = rightFilter.accept(new RelOptUtil.RexInputConverter(joinRel.getCluster().getRexBuilder(), right.getRowType().getFieldList(), joinRel.getRowType().getFieldList(), adjustments));
        return rightFilter;
    }

    private Map<Integer, ImmutableIntList> addOnJoinFieldRefCounts(List<RelNode> multiJoinInputs, int nTotalFields, RexNode joinCondition, List<int[]> origJoinFieldRefCounts) {
        int[] joinCondRefCounts = new int[nTotalFields];
        joinCondition.accept(new InputReferenceCounter(joinCondRefCounts));
        HashMap<Integer, int[]> refCountsMap = new HashMap<Integer, int[]>();
        int nInputs = multiJoinInputs.size();
        int currInput = 0;
        for (int[] origRefCounts : origJoinFieldRefCounts) {
            refCountsMap.put(currInput, (int[])origRefCounts.clone());
            ++currInput;
        }
        currInput = -1;
        int startField = 0;
        int nFields = 0;
        for (int i = 0; i < nTotalFields; ++i) {
            if (joinCondRefCounts[i] == 0) continue;
            while (i >= startField + nFields) {
                startField += nFields;
                assert (++currInput < nInputs);
                nFields = multiJoinInputs.get(currInput).getRowType().getFieldCount();
            }
            int[] refCounts = (int[])refCountsMap.get(currInput);
            int n = i - startField;
            refCounts[n] = refCounts[n] + joinCondRefCounts[i];
        }
        HashMap<Integer, ImmutableIntList> aMap = new HashMap<Integer, ImmutableIntList>();
        for (Map.Entry entry : refCountsMap.entrySet()) {
            aMap.put((Integer)entry.getKey(), ImmutableIntList.of((int[])entry.getValue()));
        }
        return Collections.unmodifiableMap(aMap);
    }

    private List<RexNode> combinePostJoinFilters(Join joinRel, RelNode left, RelNode right) {
        ArrayList<RexNode> filters = new ArrayList<RexNode>();
        if (right instanceof MultiJoin) {
            MultiJoin multiRight = (MultiJoin)right;
            filters.add(this.shiftRightFilter(joinRel, left, multiRight, multiRight.getPostJoinFilter()));
        }
        if (left instanceof MultiJoin) {
            filters.add(((MultiJoin)left).getPostJoinFilter());
        }
        return filters;
    }

    private boolean isIntervalJoin(Join join) {
        if (!(join instanceof LogicalJoin)) {
            return true;
        }
        return IntervalJoinUtil.satisfyIntervalJoin(join);
    }

    private boolean isTemporalJoin(RelOptRuleCall call) {
        Object left = call.rel(1);
        Object right = call.rel(2);
        return this.containsSnapshot((RelNode)left) || this.containsSnapshot((RelNode)right);
    }

    private boolean containsSnapshot(RelNode relNode) {
        RelNode original = relNode instanceof RelSubset ? ((RelSubset)relNode).getOriginal() : (relNode instanceof HepRelVertex ? ((HepRelVertex)relNode).getCurrentRel() : relNode);
        if (original instanceof LogicalSnapshot) {
            return true;
        }
        if (original instanceof SingleRel) {
            return this.containsSnapshot(((SingleRel)original).getInput());
        }
        return false;
    }

    private void handleStateTtlHintsForInput(RelHint.Builder builder, RelNode input, Join origJoin, String joinSide) {
        if (this.canCombine(input, origJoin)) {
            MultiJoin multiJoin = (MultiJoin)input;
            multiJoin.getHints().stream().filter(hint -> hint.hintName.equals(StateTtlHint.STATE_TTL.getHintName())).forEach(hint -> hint.listOptions.forEach(builder::hintOption));
        } else {
            this.extractStateTtlHint(builder, origJoin, joinSide);
        }
    }

    private void extractStateTtlHint(RelHint.Builder builder, Join origJoin, String joinSide) {
        List stateTtlHints = origJoin.getHints().stream().filter(hint -> hint.hintName.equals(StateTtlHint.STATE_TTL.getHintName())).collect(Collectors.toList());
        String ttlValue = null;
        for (RelHint stateTtlHint : stateTtlHints) {
            String hintTtlValue = stateTtlHint.kvOptions.get(joinSide);
            if (hintTtlValue == null) continue;
            ttlValue = hintTtlValue;
        }
        builder.hintOption(Objects.requireNonNullElse(ttlValue, "0s"));
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableJoinToMultiJoinRule.Config.builder().build().as(Config.class).withOperandFor(LogicalJoin.class);

        @Override
        default public JoinToMultiJoinRule toRule() {
            return new JoinToMultiJoinRule(this);
        }

        default public Config withOperandFor(Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b0 -> b0.operand(joinClass).inputs(b1 -> b1.operand(RelNode.class).anyInputs(), b2 -> b2.operand(RelNode.class).anyInputs())).as(Config.class);
        }
    }

    private static class InputReferenceCounter
    extends RexVisitorImpl<Void> {
        private final int[] refCounts;

        InputReferenceCounter(int[] refCounts) {
            super(true);
            this.refCounts = refCounts;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            int n = inputRef.getIndex();
            this.refCounts[n] = this.refCounts[n] + 1;
            return null;
        }
    }
}

