/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableSimplifyJoinConditionRule;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;
import org.immutables.value.Value;

@Value.Enclosing
public class SimplifyJoinConditionRule
extends RelRule<SimplifyJoinConditionRuleConfig> {
    public static final SimplifyJoinConditionRule INSTANCE = SimplifyJoinConditionRuleConfig.DEFAULT.toRule();

    protected SimplifyJoinConditionRule(SimplifyJoinConditionRuleConfig config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalJoin join = (LogicalJoin)call.rel(0);
        RexNode condition = join.getCondition();
        if (join.getCondition().isAlwaysTrue()) {
            return;
        }
        RexNode simpleCondExp = FlinkRexUtil.simplify(join.getCluster().getRexBuilder(), condition, join.getCluster().getPlanner().getExecutor());
        RexNode newCondExp = RexUtil.pullFactors(join.getCluster().getRexBuilder(), simpleCondExp);
        if (newCondExp.equals(condition)) {
            return;
        }
        LogicalJoin newJoin = join.copy(join.getTraitSet(), newCondExp, join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone());
        call.transformTo(newJoin);
        call.getPlanner().prune(join);
    }

    @Value.Immutable(singleton=false)
    public static interface SimplifyJoinConditionRuleConfig
    extends RelRule.Config {
        public static final SimplifyJoinConditionRuleConfig DEFAULT = ImmutableSimplifyJoinConditionRule.SimplifyJoinConditionRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalJoin.class).anyInputs()).withDescription("SimplifyJoinConditionRule");

        @Override
        default public SimplifyJoinConditionRule toRule() {
            return new SimplifyJoinConditionRule(this);
        }
    }
}

