/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexUtil;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCorrelate;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRel;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableFunctionScan;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableSplitPythonConditionFromCorrelateRule;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalCorrelateRule;
import org.apache.flink.table.planner.plan.utils.PythonUtil;
import org.apache.flink.table.planner.plan.utils.RexDefaultVisitor;
import org.immutables.value.Value;

@Value.Enclosing
public class SplitPythonConditionFromCorrelateRule
extends RelRule<SplitPythonConditionFromCorrelateRuleConfig> {
    public static final SplitPythonConditionFromCorrelateRule INSTANCE = SplitPythonConditionFromCorrelateRuleConfig.DEFAULT.toRule();

    private SplitPythonConditionFromCorrelateRule(SplitPythonConditionFromCorrelateRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalCorrelate correlate = (FlinkLogicalCorrelate)call.rel(0);
        FlinkLogicalCalc right = (FlinkLogicalCalc)call.rel(2);
        JoinRelType joinType = correlate.getJoinType();
        FlinkLogicalCalc mergedCalc = StreamPhysicalCorrelateRule.getMergedCalc(right);
        FlinkLogicalTableFunctionScan tableScan = StreamPhysicalCorrelateRule.getTableScan(mergedCalc);
        return joinType == JoinRelType.INNER && PythonUtil.isNonPythonCall(tableScan.getCall()) && mergedCalc.getProgram() != null && mergedCalc.getProgram().getCondition() != null && PythonUtil.containsPythonCall(mergedCalc.getProgram().expandLocalRef(mergedCalc.getProgram().getCondition()), null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalCorrelate correlate = (FlinkLogicalCorrelate)call.rel(0);
        FlinkLogicalCalc right = (FlinkLogicalCalc)call.rel(2);
        RexBuilder rexBuilder = call.builder().getRexBuilder();
        FlinkLogicalCalc mergedCalc = StreamPhysicalCorrelateRule.getMergedCalc(right);
        RexProgram mergedCalcProgram = mergedCalc.getProgram();
        RelNode input = mergedCalc.getInput();
        List<RexNode> correlateFilters = RelOptUtil.conjunctions(mergedCalcProgram.expandLocalRef(mergedCalcProgram.getCondition()));
        List remainingFilters = correlateFilters.stream().filter(filter -> !PythonUtil.containsPythonCall(filter)).collect(Collectors.toList());
        RexNode bottomCalcCondition = RexUtil.composeConjunction(rexBuilder, remainingFilters);
        FlinkLogicalCalc newBottomCalc = new FlinkLogicalCalc(mergedCalc.getCluster(), mergedCalc.getTraitSet(), input, RexProgram.create(input.getRowType(), mergedCalcProgram.getProjectList(), bottomCalcCondition, mergedCalc.getRowType(), rexBuilder));
        FlinkLogicalCorrelate newCorrelate = new FlinkLogicalCorrelate(correlate.getCluster(), correlate.getTraitSet(), correlate.getLeft(), newBottomCalc, correlate.getCorrelationId(), correlate.getRequiredColumns(), correlate.getJoinType());
        InputRefRewriter inputRefRewriter = new InputRefRewriter(correlate.getRowType().getFieldCount() - mergedCalc.getRowType().getFieldCount());
        List pythonFilters = correlateFilters.stream().filter(filter -> PythonUtil.containsPythonCall(filter)).map(filter -> filter.accept(inputRefRewriter)).collect(Collectors.toList());
        RexNode topCalcCondition = RexUtil.composeConjunction(rexBuilder, pythonFilters);
        RexProgram rexProgram = new RexProgramBuilder(newCorrelate.getRowType(), rexBuilder).getProgram();
        FlinkLogicalCalc newTopCalc = new FlinkLogicalCalc(newCorrelate.getCluster(), newCorrelate.getTraitSet(), newCorrelate, RexProgram.create(newCorrelate.getRowType(), rexProgram.getExprList(), topCalcCondition, newCorrelate.getRowType(), rexBuilder));
        call.transformTo(newTopCalc);
    }

    static class InputRefRewriter
    extends RexDefaultVisitor<RexNode> {
        private final int offset;

        public InputRefRewriter(int offset) {
            this.offset = offset;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            return new RexInputRef(inputRef.getIndex() + this.offset, inputRef.getType());
        }

        @Override
        public RexNode visitCall(RexCall call) {
            return call.clone(call.getType(), call.getOperands().stream().map(o -> o.accept(this)).collect(Collectors.toList()));
        }

        @Override
        public RexNode visitNode(RexNode rexNode) {
            return rexNode;
        }
    }

    @Value.Immutable(singleton=false)
    public static interface SplitPythonConditionFromCorrelateRuleConfig
    extends RelRule.Config {
        public static final SplitPythonConditionFromCorrelateRuleConfig DEFAULT = ImmutableSplitPythonConditionFromCorrelateRule.SplitPythonConditionFromCorrelateRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(FlinkLogicalCorrelate.class).inputs(b1 -> b1.operand(FlinkLogicalRel.class).anyInputs(), b2 -> b2.operand(FlinkLogicalCalc.class).anyInputs())).withDescription("SplitPythonConditionFromCorrelateRule");

        @Override
        default public SplitPythonConditionFromCorrelateRule toRule() {
            return new SplitPythonConditionFromCorrelateRule(this);
        }
    }
}

