/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalCalc;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalChangelogNormalize;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;

public class FlinkMarkChangelogNormalizeProgram
implements FlinkOptimizeProgram<StreamOptimizeContext> {
    @Override
    public RelNode optimize(RelNode root, StreamOptimizeContext context) {
        HashMap<TableScan, List<ChangelogNormalizeContext>> tableScansToChangelogNormalize = new HashMap<TableScan, List<ChangelogNormalizeContext>>();
        FlinkRexBuilder rexBuilder = new FlinkRexBuilder(context.getFlinkRelBuilder().getTypeFactory());
        for (RelNode relNode : root.getInputs()) {
            this.gatherTableScanToChangelogNormalizeMap(relNode, tableScansToChangelogNormalize, rexBuilder);
        }
        for (Map.Entry entry : tableScansToChangelogNormalize.entrySet()) {
            List changelogNormalizeContexts = (List)entry.getValue();
            if (changelogNormalizeContexts.size() <= 1) continue;
            Set<RexNode> common = this.calculateCommonCondition(changelogNormalizeContexts);
            for (ChangelogNormalizeContext ctx : changelogNormalizeContexts) {
                ctx.getChangelogNormalize().markSourceReuse();
                if (common.isEmpty()) continue;
                ctx.getChangelogNormalize().setCommonFilter(common.toArray(new RexNode[0]));
            }
        }
        return root;
    }

    private Set<RexNode> calculateCommonCondition(List<ChangelogNormalizeContext> changelogNormalizeContexts) {
        changelogNormalizeContexts.sort(Comparator.comparingInt(o -> o.getConditions().size()));
        HashSet<RexNode> common = new HashSet<RexNode>(changelogNormalizeContexts.get(0).getConditions());
        for (int i = 1; i < changelogNormalizeContexts.size() && !common.isEmpty(); ++i) {
            common.retainAll(changelogNormalizeContexts.get(i).getConditions());
        }
        return common;
    }

    private void gatherTableScanToChangelogNormalizeMap(RelNode curRelNode, Map<TableScan, List<ChangelogNormalizeContext>> map, FlinkRexBuilder rexBuilder) {
        for (RelNode input : curRelNode.getInputs()) {
            if (input instanceof StreamPhysicalChangelogNormalize) {
                StreamPhysicalChangelogNormalize changelogNormalize = (StreamPhysicalChangelogNormalize)input;
                if (!(curRelNode instanceof StreamPhysicalCalc)) continue;
                StreamPhysicalCalc calc = (StreamPhysicalCalc)curRelNode;
                List<RexNode> conditions = FlinkRexUtil.extractConjunctiveConditions(rexBuilder, calc.getProgram());
                this.gatherTableScanToChangelogNormalizeMap(input, ChangelogNormalizeContext.of(changelogNormalize, conditions), map);
                continue;
            }
            this.gatherTableScanToChangelogNormalizeMap(input, map, rexBuilder);
        }
    }

    private void gatherTableScanToChangelogNormalizeMap(RelNode cur, ChangelogNormalizeContext context, Map<TableScan, List<ChangelogNormalizeContext>> currentMap) {
        if (cur instanceof TableScan) {
            currentMap.computeIfAbsent((TableScan)cur, k -> new ArrayList()).add(context);
        } else {
            for (RelNode relNode : cur.getInputs()) {
                this.gatherTableScanToChangelogNormalizeMap(relNode, context, currentMap);
            }
        }
    }

    private static class ChangelogNormalizeContext {
        private final StreamPhysicalChangelogNormalize changelogNormalize;
        private final List<RexNode> conditions;

        public ChangelogNormalizeContext(StreamPhysicalChangelogNormalize changelogNormalize, List<RexNode> conditions) {
            this.changelogNormalize = changelogNormalize;
            this.conditions = conditions;
        }

        public static ChangelogNormalizeContext of(StreamPhysicalChangelogNormalize changelogNormalize, List<RexNode> conditions) {
            return new ChangelogNormalizeContext(changelogNormalize, conditions);
        }

        public StreamPhysicalChangelogNormalize getChangelogNormalize() {
            return this.changelogNormalize;
        }

        public List<RexNode> getConditions() {
            return this.conditions;
        }
    }
}

