/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalMultiJoin;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalMultiJoin;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.utils.MultiJoinUtil;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.AttributeBasedJoinKeyExtractor;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.JoinKeyExtractor;

public class StreamPhysicalMultiJoinRule
extends ConverterRule {
    public static final RelOptRule INSTANCE = new StreamPhysicalMultiJoinRule();

    private StreamPhysicalMultiJoinRule() {
        super(ConverterRule.Config.INSTANCE.withConversion(FlinkLogicalMultiJoin.class, FlinkConventions.LOGICAL(), FlinkConventions.STREAM_PHYSICAL(), "StreamPhysicalMultiJoinRule"));
    }

    @Override
    public RelNode convert(RelNode rel) {
        FlinkLogicalMultiJoin multiJoin = (FlinkLogicalMultiJoin)rel;
        Map<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>> joinAttributeMap = MultiJoinUtil.createJoinAttributeMap(multiJoin.getInputs(), multiJoin.getJoinConditions());
        List inputRowTypes = multiJoin.getInputs().stream().map(i -> FlinkTypeFactory.toLogicalRowType(i.getRowType())).collect(Collectors.toList());
        AttributeBasedJoinKeyExtractor keyExtractor = new AttributeBasedJoinKeyExtractor(joinAttributeMap, inputRowTypes);
        List<RelNode> newInputs = this.createHashDistributedInputs(multiJoin.getInputs(), (JoinKeyExtractor)keyExtractor);
        RelTraitSet traitSet = rel.getTraitSet().replace(FlinkConventions.STREAM_PHYSICAL());
        return new StreamPhysicalMultiJoin(multiJoin.getCluster(), traitSet, newInputs, multiJoin.getJoinFilter(), multiJoin.getRowType(), multiJoin.getJoinConditions(), multiJoin.getJoinTypes(), joinAttributeMap, multiJoin.getPostJoinFilter(), multiJoin.getHints(), (JoinKeyExtractor)keyExtractor);
    }

    private List<RelNode> createHashDistributedInputs(List<RelNode> inputs, JoinKeyExtractor keyExtractor) {
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        for (int i = 0; i < inputs.size(); ++i) {
            RelNode input = inputs.get(i);
            RelTraitSet inputTraitSet = this.createInputTraitSet(input, keyExtractor, i);
            RelNode convertedInput = RelOptRule.convert(input, inputTraitSet.simplify());
            newInputs.add(convertedInput);
        }
        return newInputs;
    }

    private RelTraitSet createInputTraitSet(RelNode input, JoinKeyExtractor keyExtractor, int inputIndex) {
        int[] commonJoinKeyIndices = keyExtractor.getCommonJoinKeyIndices(inputIndex);
        RelTraitSet inputTraitSet = input.getTraitSet().replace(FlinkConventions.STREAM_PHYSICAL());
        if (commonJoinKeyIndices.length > 0) {
            FlinkRelDistribution hashDistribution = FlinkRelDistribution.hash(commonJoinKeyIndices, true);
            inputTraitSet = inputTraitSet.replace(hashDistribution);
        } else {
            inputTraitSet = inputTraitSet.replace(FlinkRelDistribution.SINGLETON());
        }
        return inputTraitSet;
    }
}

