/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.MultipleExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecCalc;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecCorrelate;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecExchange;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecExpand;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecHashAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecHashJoin;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecLimit;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecLookupJoin;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecMatch;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNestedLoopJoin;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecOverAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecRank;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecSink;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecSort;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecSortAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecSortLimit;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecUnion;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecValues;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecWindowTableFunction;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecAsyncCalc;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecAsyncCorrelate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecCalc;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecChangelogNormalize;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecCorrelate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecDataStreamScan;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecDeduplicate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecDeltaJoin;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecDropUpdateBefore;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecExchange;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecExpand;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecGlobalGroupAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecGlobalWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecGroupAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecGroupTableAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecGroupWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecIncrementalGroupAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecIntervalJoin;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecJoin;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecLegacySink;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecLimit;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecLocalGroupAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecLocalWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecLookupJoin;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecMLPredictTableFunction;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecMatch;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecMiniBatchAssigner;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecMultiJoin;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecMultipleInput;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecOverAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecProcessTableFunction;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecPythonCalc;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecPythonCorrelate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecPythonGroupAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecPythonGroupTableAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecPythonGroupWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecPythonOverAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecRank;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecSink;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecSort;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecSortLimit;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecTemporalJoin;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecTemporalSort;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecUnion;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecValues;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecVectorSearchTableFunction;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecWatermarkAssigner;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecWindowDeduplicate;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecWindowJoin;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecWindowRank;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecWindowTableFunction;

@Internal
public final class ExecNodeMetadataUtil {
    private static final Set<Class<? extends ExecNode<?>>> EXEC_NODES = new HashSet<Class<? extends ExecNode<?>>>(){
        {
            this.add(StreamExecCalc.class);
            this.add(StreamExecChangelogNormalize.class);
            this.add(StreamExecCorrelate.class);
            this.add(StreamExecDeduplicate.class);
            this.add(StreamExecDropUpdateBefore.class);
            this.add(StreamExecExchange.class);
            this.add(StreamExecExpand.class);
            this.add(StreamExecGlobalGroupAggregate.class);
            this.add(StreamExecGlobalWindowAggregate.class);
            this.add(StreamExecGroupAggregate.class);
            this.add(StreamExecGroupWindowAggregate.class);
            this.add(StreamExecIncrementalGroupAggregate.class);
            this.add(StreamExecIntervalJoin.class);
            this.add(StreamExecJoin.class);
            this.add(StreamExecLimit.class);
            this.add(StreamExecLocalGroupAggregate.class);
            this.add(StreamExecLocalWindowAggregate.class);
            this.add(StreamExecLookupJoin.class);
            this.add(StreamExecMatch.class);
            this.add(StreamExecMiniBatchAssigner.class);
            this.add(StreamExecMultiJoin.class);
            this.add(StreamExecOverAggregate.class);
            this.add(StreamExecRank.class);
            this.add(StreamExecSink.class);
            this.add(StreamExecSortLimit.class);
            this.add(StreamExecSort.class);
            this.add(StreamExecTableSourceScan.class);
            this.add(StreamExecTemporalJoin.class);
            this.add(StreamExecTemporalSort.class);
            this.add(StreamExecUnion.class);
            this.add(StreamExecValues.class);
            this.add(StreamExecWatermarkAssigner.class);
            this.add(StreamExecWindowAggregate.class);
            this.add(StreamExecWindowDeduplicate.class);
            this.add(StreamExecWindowJoin.class);
            this.add(StreamExecWindowRank.class);
            this.add(StreamExecWindowTableFunction.class);
            this.add(StreamExecPythonCalc.class);
            this.add(StreamExecAsyncCalc.class);
            this.add(StreamExecProcessTableFunction.class);
            this.add(StreamExecAsyncCorrelate.class);
            this.add(StreamExecPythonCorrelate.class);
            this.add(StreamExecPythonGroupAggregate.class);
            this.add(StreamExecPythonGroupWindowAggregate.class);
            this.add(StreamExecPythonOverAggregate.class);
            this.add(StreamExecMLPredictTableFunction.class);
            this.add(StreamExecDeltaJoin.class);
            this.add(StreamExecVectorSearchTableFunction.class);
            this.add(BatchExecSink.class);
            this.add(BatchExecTableSourceScan.class);
            this.add(BatchExecCalc.class);
            this.add(BatchExecExchange.class);
            this.add(BatchExecSort.class);
            this.add(BatchExecValues.class);
            this.add(BatchExecCorrelate.class);
            this.add(BatchExecHashJoin.class);
            this.add(BatchExecNestedLoopJoin.class);
            this.add(BatchExecLimit.class);
            this.add(BatchExecUnion.class);
            this.add(BatchExecHashAggregate.class);
            this.add(BatchExecExpand.class);
            this.add(BatchExecSortAggregate.class);
            this.add(BatchExecSortLimit.class);
            this.add(BatchExecWindowTableFunction.class);
            this.add(BatchExecLookupJoin.class);
            this.add(BatchExecMatch.class);
            this.add(BatchExecOverAggregate.class);
            this.add(BatchExecRank.class);
        }
    };
    private static final Map<ExecNodeNameVersion, Class<? extends ExecNode<?>>> LOOKUP_MAP = new HashMap();
    static final Set<Class<? extends ExecNode>> UNSUPPORTED_JSON_SERDE_CLASSES;
    public static final Set<ConfigOption<?>> TABLE_CONFIG_OPTIONS;
    public static final Set<ConfigOption<?>> EXECUTION_CONFIG_OPTIONS;

    private ExecNodeMetadataUtil() {
    }

    public static Set<Class<? extends ExecNode<?>>> execNodes() {
        return EXEC_NODES;
    }

    public static Map<ExecNodeNameVersion, Class<? extends ExecNode<?>>> getVersionedExecNodes() {
        return LOOKUP_MAP;
    }

    public static Class<? extends ExecNode<?>> retrieveExecNode(String name, int version) {
        return LOOKUP_MAP.get(new ExecNodeNameVersion(name, version));
    }

    public static <T extends ExecNode<?>> boolean isUnsupported(Class<T> execNode) {
        boolean streamOrKnownExecNode = StreamExecNode.class.isAssignableFrom(execNode) || ExecNodeMetadataUtil.execNodes().contains(execNode);
        return !streamOrKnownExecNode || UNSUPPORTED_JSON_SERDE_CLASSES.contains(execNode);
    }

    public static void addTestNode(Class<? extends ExecNode<?>> execNodeClass) {
        ExecNodeMetadataUtil.addToLookupMap(execNodeClass);
    }

    public static <T extends ExecNode<?>> List<ExecNodeMetadata> extractMetadataFromAnnotation(Class<T> execNodeClass) {
        MultipleExecNodeMetadata annotations;
        ArrayList<ExecNodeMetadata> metadata = new ArrayList<ExecNodeMetadata>();
        ExecNodeMetadata annotation = execNodeClass.getDeclaredAnnotation(ExecNodeMetadata.class);
        if (annotation != null) {
            metadata.add(annotation);
        }
        if ((annotations = execNodeClass.getDeclaredAnnotation(MultipleExecNodeMetadata.class)) != null) {
            if (metadata.isEmpty()) {
                for (ExecNodeMetadata annot : annotations.value()) {
                    if (annot == null) continue;
                    metadata.add(annot);
                }
            } else {
                throw new IllegalStateException(String.format("ExecNode: %s is annotated both with %s and %s. Please use only %s or multiple %s", execNodeClass.getCanonicalName(), ExecNodeMetadata.class, MultipleExecNodeMetadata.class, MultipleExecNodeMetadata.class, ExecNodeMetadata.class));
            }
        }
        return metadata;
    }

    private static void addToLookupMap(Class<? extends ExecNode<?>> execNodeClass) {
        if (!ExecNodeMetadataUtil.hasJsonCreatorAnnotation(execNodeClass)) {
            throw new IllegalStateException(String.format("ExecNode: %s does not implement @JsonCreator annotation on constructor.", execNodeClass.getCanonicalName()));
        }
        List<ExecNodeMetadata> metadata = ExecNodeMetadataUtil.extractMetadataFromAnnotation(execNodeClass);
        if (metadata.isEmpty()) {
            throw new IllegalStateException(String.format("ExecNode: %s is missing %s annotation.", execNodeClass.getCanonicalName(), ExecNodeMetadata.class.getSimpleName()));
        }
        for (ExecNodeMetadata meta : metadata) {
            ExecNodeMetadataUtil.doAddToMap(new ExecNodeNameVersion(meta.name(), meta.version()), execNodeClass);
        }
    }

    private static void doAddToMap(ExecNodeNameVersion key, Class<? extends ExecNode<?>> execNodeClass) {
        if (LOOKUP_MAP.containsKey(key)) {
            throw new IllegalStateException(String.format("Found duplicate ExecNode: %s.", key));
        }
        LOOKUP_MAP.put(key, execNodeClass);
    }

    public static <T extends ExecNode<?>> ExecNodeMetadata latestAnnotation(Class<T> execNodeClass) {
        List<ExecNodeMetadata> sortedAnnotations = ExecNodeMetadataUtil.extractMetadataFromAnnotation(execNodeClass);
        if (sortedAnnotations.isEmpty()) {
            return null;
        }
        sortedAnnotations.sort(Comparator.comparingInt(ExecNodeMetadata::version));
        return sortedAnnotations.get(sortedAnnotations.size() - 1);
    }

    @Nullable
    public static <T extends ExecNode<?>> String[] consumedOptions(Class<T> execNodeClass) {
        ExecNodeMetadata metadata = ExecNodeMetadataUtil.latestAnnotation(execNodeClass);
        if (metadata == null) {
            return null;
        }
        return metadata.consumedOptions();
    }

    public static <T extends ExecNode<?>> ReadableConfig newPersistedConfig(Class<T> execNodeClass, ReadableConfig tableConfig, Stream<ConfigOption<?>> configOptions) {
        HashMap availableConfigOptions = new HashMap();
        configOptions.forEach(co -> {
            availableConfigOptions.put(co.key(), co);
            co.fallbackKeys().forEach(k -> availableConfigOptions.put(k.getKey(), co));
        });
        Configuration persistedConfig = new Configuration();
        String[] consumedOptions = ExecNodeMetadataUtil.consumedOptions(execNodeClass);
        if (consumedOptions == null) {
            return persistedConfig;
        }
        HashMap<ConfigOption, Object> nodeConfigOptions = new HashMap<ConfigOption, Object>();
        for (String consumedOption : consumedOptions) {
            ConfigOption configOption = (ConfigOption)availableConfigOptions.get(consumedOption);
            if (configOption == null) {
                throw new IllegalStateException(String.format("ExecNode: %s, consumedOption: %s not listed in [%s].", execNodeClass.getCanonicalName(), consumedOption, String.join((CharSequence)", ", Arrays.asList(TableConfigOptions.class.getSimpleName(), ExecutionConfigOptions.class.getSimpleName()))));
            }
            if (nodeConfigOptions.containsKey(configOption)) {
                throw new IllegalStateException(String.format("ExecNode: %s, consumedOption: %s is listed multiple times in consumedOptions, potentially also with fallback/deprecated key.", execNodeClass.getCanonicalName(), consumedOption));
            }
            nodeConfigOptions.put(configOption, tableConfig.get(configOption));
        }
        nodeConfigOptions.forEach((arg_0, arg_1) -> ((Configuration)persistedConfig).set(arg_0, arg_1));
        return persistedConfig;
    }

    static boolean hasJsonCreatorAnnotation(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            for (Annotation annotation : constructor.getAnnotations()) {
                if (!(annotation instanceof JsonCreator)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        for (Class<? extends ExecNode<?>> clazz : EXEC_NODES) {
            ExecNodeMetadataUtil.addToLookupMap(clazz);
        }
        UNSUPPORTED_JSON_SERDE_CLASSES = new HashSet<Class<? extends ExecNode>>(){
            {
                this.add(StreamExecDataStreamScan.class);
                this.add(StreamExecLegacyTableSourceScan.class);
                this.add(StreamExecLegacySink.class);
                this.add(StreamExecGroupTableAggregate.class);
                this.add(StreamExecPythonGroupTableAggregate.class);
                this.add(StreamExecMultipleInput.class);
            }
        };
        TABLE_CONFIG_OPTIONS = ConfigUtils.getAllConfigOptions(TableConfigOptions.class);
        EXECUTION_CONFIG_OPTIONS = ConfigUtils.getAllConfigOptions(ExecutionConfigOptions.class);
    }

    public static final class ExecNodeNameVersion {
        private final String name;
        private final int version;

        private ExecNodeNameVersion(String name, int version) {
            this.name = name;
            this.version = version;
        }

        public String toString() {
            return String.format("name: %s, version: %s", this.name, this.version);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecNodeNameVersion that = (ExecNodeNameVersion)o;
            return this.version == that.version && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.version);
        }
    }
}

