/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.trait.RelModifiedMonotonicity;
import org.apache.flink.table.planner.plan.utils.ChangelogPlanUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=UndefinedStrategy.class), @JsonSubTypes.Type(value=AppendFastStrategy.class), @JsonSubTypes.Type(value=RetractStrategy.class), @JsonSubTypes.Type(value=UpdateFastStrategy.class)})
public interface RankProcessStrategy {
    public static final UndefinedStrategy UNDEFINED_STRATEGY = new UndefinedStrategy();
    public static final AppendFastStrategy APPEND_FAST_STRATEGY = new AppendFastStrategy();
    public static final RetractStrategy RETRACT_STRATEGY = new RetractStrategy();

    public static List<RankProcessStrategy> analyzeRankProcessStrategies(StreamPhysicalRel rank, ImmutableBitSet partitionKey, RelCollation orderKey) {
        FlinkRelMetadataQuery mq = (FlinkRelMetadataQuery)rank.getCluster().getMetadataQuery();
        List<RelFieldCollation> fieldCollations = orderKey.getFieldCollations();
        boolean isUpdateStream = !ChangelogPlanUtils.inputInsertOnly(rank);
        RelNode input = rank.getInput(0);
        if (isUpdateStream) {
            Set<ImmutableBitSet> upsertKeys = mq.getUpsertKeysInKeyGroupRange(input, partitionKey.toArray());
            if (upsertKeys == null || upsertKeys.isEmpty() || upsertKeys.stream().noneMatch(k -> k.contains(partitionKey))) {
                return Collections.singletonList(RETRACT_STRATEGY);
            }
            FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(mq);
            RelModifiedMonotonicity monotonicity = fmq.getRelModifiedMonotonicity(input);
            boolean isMonotonic = false;
            if (monotonicity != null && !fieldCollations.isEmpty()) {
                isMonotonic = fieldCollations.stream().allMatch(collation -> {
                    SqlMonotonicity fieldMonotonicity = monotonicity.fieldMonotonicities()[collation.getFieldIndex()];
                    RelFieldCollation.Direction direction = collation.direction;
                    if ((fieldMonotonicity == SqlMonotonicity.DECREASING || fieldMonotonicity == SqlMonotonicity.STRICTLY_DECREASING) && direction == RelFieldCollation.Direction.ASCENDING) {
                        return true;
                    }
                    if ((fieldMonotonicity == SqlMonotonicity.INCREASING || fieldMonotonicity == SqlMonotonicity.STRICTLY_INCREASING) && direction == RelFieldCollation.Direction.DESCENDING) {
                        return true;
                    }
                    return fieldMonotonicity == SqlMonotonicity.CONSTANT;
                });
            }
            if (isMonotonic) {
                return Arrays.asList(new UpdateFastStrategy(upsertKeys.iterator().next().toArray()), RETRACT_STRATEGY);
            }
            return Collections.singletonList(RETRACT_STRATEGY);
        }
        return Collections.singletonList(APPEND_FAST_STRATEGY);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonTypeName(value="UpdateFast")
    public static class UpdateFastStrategy
    implements RankProcessStrategy {
        public static final String FIELD_NAME_PRIMARY_KEYS = "primaryKeys";
        @JsonProperty(value="primaryKeys")
        private final int[] primaryKeys;

        @JsonCreator
        public UpdateFastStrategy(@JsonProperty(value="primaryKeys") int[] primaryKeys) {
            this.primaryKeys = primaryKeys;
        }

        @JsonIgnore
        public int[] getPrimaryKeys() {
            return this.primaryKeys;
        }

        public String toString() {
            return String.format("UpdateFastStrategy[%s]", StringUtils.join((int[])this.primaryKeys, (char)','));
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonTypeName(value="Retract")
    public static class RetractStrategy
    implements RankProcessStrategy {
        @JsonCreator
        public RetractStrategy() {
        }

        public String toString() {
            return "RetractStrategy";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonTypeName(value="AppendFast")
    public static class AppendFastStrategy
    implements RankProcessStrategy {
        @JsonCreator
        public AppendFastStrategy() {
        }

        public String toString() {
            return "AppendFastStrategy";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonTypeName(value="Undefined")
    public static class UndefinedStrategy
    implements RankProcessStrategy {
        @JsonCreator
        public UndefinedStrategy() {
        }

        public String toString() {
            return "UndefinedStrategy";
        }
    }
}

