/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.time.Duration;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy$;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.ElementTriggers;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.EventTimeTriggers;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.ProcessingTimeTriggers;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.Trigger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0010!\u0001=B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005o!AA\n\u0001B\u0001B\u0003%Q\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u00038\u0011!1\u0006A!A!\u0002\u0013i\u0005\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011a\u0003!\u0011!Q\u0001\neCQ\u0001\u0018\u0001\u0005\u0002uCQa\u001a\u0001\u0005\u0002!DQ!\u001b\u0001\u0005\n)DQA\u001c\u0001\u0005\u0002=DQ\u0001\u001d\u0001\u0005\u0002EDq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002\u001e\u0001!I!a\b\t\u000f\u0005=\u0002\u0001\"\u0003\u00022\u001d9\u0011q\u0007\u0011\t\u0002\u0005ebAB\u0010!\u0011\u0003\tY\u0004\u0003\u0004]#\u0011\u0005\u0011Q\b\u0005\b\u0003\u007f\tB\u0011AA!\u0011\u001d\t\t'\u0005C\u0005\u0003GB\u0011\"!\u001e\u0012\u0005\u0004%\t!a\u001e\t\u0011\u0005}\u0014\u0003)A\u0005\u0003sB\u0011\"a$\u0012\u0005\u0004%\t!!%\t\u0011\u0005U\u0015\u0003)A\u0005\u0003'C\u0011\"!'\u0012\u0005\u0004%\t!a\u001e\t\u0011\u0005m\u0015\u0003)A\u0005\u0003sB\u0011\"a(\u0012\u0005\u0004%\t!!%\t\u0011\u0005\u0005\u0016\u0003)A\u0005\u0003'C\u0011\"!*\u0012\u0005\u0004%\t!!%\t\u0011\u0005\u001d\u0016\u0003)A\u0005\u0003'\u0013!cV5oI><X)\\5u'R\u0014\u0018\r^3hs*\u0011\u0011EI\u0001\u0006kRLGn\u001d\u0006\u0003G\u0011\nA\u0001\u001d7b]*\u0011QEJ\u0001\ba2\fgN\\3s\u0015\t9\u0003&A\u0003uC\ndWM\u0003\u0002*U\u0005)a\r\\5oW*\u00111\u0006L\u0001\u0007CB\f7\r[3\u000b\u00035\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0019\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g\u0003-I7/\u0012<f]R$\u0016.\\3\u0011\u0005aBeBA\u001dG\u001d\tQTI\u0004\u0002<\t:\u0011Ah\u0011\b\u0003{\ts!AP!\u000e\u0003}R!\u0001\u0011\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0013BA\u0016-\u0013\tI#&\u0003\u0002(Q%\u0011QEJ\u0005\u0003\u000f\u0012\nq\u0001]1dW\u0006<W-\u0003\u0002J\u0015\nA!JQ8pY\u0016\fgN\u0003\u0002HI\u0005y\u0011n]*fgNLwN\\,j]\u0012|w/\u0001\bfCJd\u0017PR5sK\u0012+G.Y=\u0011\u00059\u001bV\"A(\u000b\u0005A\u000b\u0016\u0001\u0002;j[\u0016T\u0011AU\u0001\u0005U\u00064\u0018-\u0003\u0002U\u001f\nAA)\u001e:bi&|g.A\u000bfCJd\u0017PR5sK\u0012+G.Y=F]\u0006\u0014G.\u001a3\u0002\u001b1\fG/\u001a$je\u0016$U\r\\1z\u0003Qa\u0017\r^3GSJ,G)\u001a7bs\u0016s\u0017M\u00197fI\u0006i\u0011\r\u001c7po2\u000bG/\u001a8fgN\u0004\"\u0001\u000f.\n\u0005mS%!\u0002&M_:<\u0017A\u0002\u001fj]&$h\b\u0006\u0005_A\u0006\u00147\rZ3g!\ty\u0006!D\u0001!\u0011\u00151\u0004\u00021\u00018\u0011\u0015Y\u0005\u00021\u00018\u0011\u0015a\u0005\u00021\u0001N\u0011\u0015)\u0006\u00021\u00018\u0011\u00151\u0006\u00021\u0001N\u0011\u00159\u0006\u00021\u00018\u0011\u0015A\u0006\u00021\u0001Z\u0003A9W\r^!mY><H*\u0019;f]\u0016\u001c8/F\u0001Z\u0003=\u0019\u0007.Z2l-\u0006d\u0017\u000eZ1uS>tG#A6\u0011\u0005Eb\u0017BA73\u0005\u0011)f.\u001b;\u0002\u001dA\u0014x\u000eZ;dKV\u0003H-\u0019;fgV\tq'\u0001\u0006hKR$&/[4hKJ,\u0012A\u001d\t\u0005gz\f\t!D\u0001u\u0015\t)h/\u0001\u0005ue&<w-\u001a:t\u0015\t9\b0A\u0006he>,\bo^5oI><(BA={\u0003\u00199\u0018N\u001c3po*\u00111\u0010`\u0001\n_B,'/\u0019;peNT!! \u0014\u0002\u000fI,h\u000e^5nK&\u0011q\u0010\u001e\u0002\b)JLwmZ3s!\u0011\t\u0019!!\u0002\u000e\u0003aL1!a\u0002y\u0005)!\u0016.\\3XS:$wn^\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u0002\t\u0005\u0003\u001f\t9B\u0004\u0003\u0002\u0012\u0005M\u0001C\u0001 3\u0013\r\t)BM\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00111\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005U!'\u0001\u000ede\u0016\fG/\u001a+sS\u001e<WM\u001d$s_64\u0015N]3EK2\f\u0017\u0010\u0006\u0004\u0002\"\u0005\u001d\u00121\u0006\t\u0005c\u0005\r\"/C\u0002\u0002&I\u0012aa\u00149uS>t\u0007BBA\u0015\u001d\u0001\u0007q'A\bf]\u0006\u0014G.\u001a#fY\u0006LX)\\5u\u0011\u0019\tiC\u0004a\u0001\u001b\u0006Ia-\u001b:f\t\u0016d\u0017-_\u0001\u0012M&\u0014X\rR3mCf$vn\u0015;sS:<GCBA\u0007\u0003g\t)\u0004\u0003\u0004\u0002*=\u0001\ra\u000e\u0005\u0007\u0003[y\u0001\u0019A'\u0002%]Kg\u000eZ8x\u000b6LGo\u0015;sCR,w-\u001f\t\u0003?F\u0019\"!\u0005\u0019\u0015\u0005\u0005e\u0012!B1qa2LH#\u00020\u0002D\u0005M\u0003bBA#'\u0001\u0007\u0011qI\u0001\u0007G>tg-[4\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014)\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&!\u0011\u0011KA&\u00059\u0011V-\u00193bE2,7i\u001c8gS\u001eDa!_\nA\u0002\u0005U\u0003\u0003BA,\u0003;j!!!\u0017\u000b\u0007\u0005m#%A\u0004m_\u001eL7-\u00197\n\t\u0005}\u0013\u0011\f\u0002\u000e\u0019><\u0017nY1m/&tGm\\<\u0002%A\f'o]3BY2|w\u000fT1uK:,7o\u001d\u000b\u0007\u0003K\nY'a\u001d\u0011\u0007E\n9'C\u0002\u0002jI\u0012A\u0001T8oO\"11\n\u0006a\u0001\u0003[\u00022!MA8\u0013\r\t\tH\r\u0002\b\u0005>|G.Z1o\u0011\u001d\t)\u0005\u0006a\u0001\u0003\u000f\n!\u0005V!C\u0019\u0016{V\tW#D?\u0016k\u0015\nV0F\u0003Jc\u0015l\u0018$J%\u0016{VIT!C\u0019\u0016#UCAA=!\u0015\tI%a\u001f8\u0013\u0011\ti(a\u0013\u0003\u0019\r{gNZ5h\u001fB$\u0018n\u001c8\u0002GQ\u000b%\tT#`\u000bb+5iX#N\u0013R{V)\u0011*M3~3\u0015JU#`\u000b:\u000b%\tT#EA!\u001aa#a!\u0011\t\u0005\u0015\u00151R\u0007\u0003\u0003\u000fS1!!#)\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001b\u000b9I\u0001\u0007FqB,'/[7f]R\fG.\u0001\u0011U\u0003\ncUiX#Y\u000b\u000e{V)T%U?\u0016\u000b%\u000bT-`\r&\u0013Vi\u0018#F\u0019\u0006KVCAAJ!\u0015\tI%a\u001fN\u0003\u0005\"\u0016I\u0011'F?\u0016CViQ0F\u001b&#v,R!S\u0019f{f)\u0013*F?\u0012+E*Q-!Q\rA\u00121Q\u0001\")\u0006\u0013E*R0F1\u0016\u001bu,R'J)~c\u0015\tV#`\r&\u0013ViX#O\u0003\ncU\tR\u0001#)\u0006\u0013E*R0F1\u0016\u001bu,R'J)~c\u0015\tV#`\r&\u0013ViX#O\u0003\ncU\t\u0012\u0011)\u0007i\t\u0019)A\u0010U\u0003\ncUiX#Y\u000b\u000e{V)T%U?2\u000bE+R0G\u0013J+u\fR#M\u0003f\u000b\u0001\u0005V!C\u0019\u0016{V\tW#D?\u0016k\u0015\nV0M\u0003R+uLR%S\u000b~#U\tT!ZA!\u001aA$a!\u0002=Q\u000b%\tT#`\u000bb+5iX#N\u0013R{\u0016\t\u0014'P/~c\u0015\tV#O\u000bN\u001b\u0016a\b+B\u00052+u,\u0012-F\u0007~+U*\u0013+`\u00032cujV0M\u0003R+e*R*TA!\u001aa$a!")
public class WindowEmitStrategy {
    private final Boolean isEventTime;
    private final Boolean isSessionWindow;
    private final Duration earlyFireDelay;
    private final Boolean earlyFireDelayEnabled;
    private final Duration lateFireDelay;
    private final Boolean lateFireDelayEnabled;
    private final Long allowLateness;

    public static ConfigOption<Duration> TABLE_EXEC_EMIT_ALLOW_LATENESS() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_ALLOW_LATENESS();
    }

    public static ConfigOption<Duration> TABLE_EXEC_EMIT_LATE_FIRE_DELAY() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY();
    }

    public static ConfigOption<Boolean> TABLE_EXEC_EMIT_LATE_FIRE_ENABLED() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED();
    }

    public static ConfigOption<Duration> TABLE_EXEC_EMIT_EARLY_FIRE_DELAY() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_DELAY();
    }

    public static ConfigOption<Boolean> TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED();
    }

    public static WindowEmitStrategy apply(ReadableConfig readableConfig, LogicalWindow logicalWindow) {
        return WindowEmitStrategy$.MODULE$.apply(readableConfig, logicalWindow);
    }

    public Long getAllowLateness() {
        return this.allowLateness;
    }

    private void checkValidation() {
        if (Predef$.MODULE$.Boolean2boolean(this.isSessionWindow) && (Predef$.MODULE$.Boolean2boolean(this.earlyFireDelayEnabled) || Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled))) {
            throw new TableException("Session window doesn't support EMIT strategy currently.");
        }
        if (Predef$.MODULE$.Boolean2boolean(this.isEventTime) && Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled) && Predef$.MODULE$.Long2long(this.allowLateness) <= 0L) {
            throw new TableException("The 'AFTER WATERMARK' emit strategy requires set 'allow-lateness' or 'minIdleStateRetentionTime' in table config.");
        }
        if (Predef$.MODULE$.Boolean2boolean(this.earlyFireDelayEnabled) && (this.earlyFireDelay == null || this.earlyFireDelay.toMillis() < 0L)) {
            throw new TableException("Early-fire delay should not be null or negative value whenenable early-fire emit strategy.");
        }
        if (Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled) && (this.lateFireDelay == null || this.lateFireDelay.toMillis() < 0L)) {
            throw new TableException("Late-fire delay should not be null or negative value whenenable late-fire emit strategy.");
        }
        if (Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled) && this.lateFireDelay.toMillis() > Predef$.MODULE$.Long2long(this.allowLateness)) {
            throw new TableException(new StringBuilder(104).append("Allow-lateness [").append(this.allowLateness).append("ms] should not be smaller than ").append("Late-fire delay [").append(this.lateFireDelay.toMillis()).append("ms] when enable late-fire emit strategy.").toString());
        }
    }

    public Boolean produceUpdates() {
        if (Predef$.MODULE$.Boolean2boolean(this.isEventTime)) {
            return Predef$.MODULE$.boolean2Boolean(Predef$.MODULE$.Boolean2boolean(this.earlyFireDelayEnabled) || Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled));
        }
        return this.earlyFireDelayEnabled;
    }

    public Trigger<TimeWindow> getTrigger() {
        Option<Trigger<TimeWindow>> earlyTrigger = this.createTriggerFromFireDelay(this.earlyFireDelayEnabled, this.earlyFireDelay);
        Option<Trigger<TimeWindow>> lateTrigger = this.createTriggerFromFireDelay(this.lateFireDelayEnabled, this.lateFireDelay);
        if (Predef$.MODULE$.Boolean2boolean(this.isEventTime)) {
            EventTimeTriggers.AfterEndOfWindow trigger = EventTimeTriggers.afterEndOfWindow();
            Tuple2 tuple2 = new Tuple2(earlyTrigger, lateTrigger);
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Trigger early = (Trigger)some.value();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        Trigger late = (Trigger)some2.value();
                        return trigger.withEarlyFirings(early).withLateFirings(late);
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Trigger early = (Trigger)some.value();
                    if (None$.MODULE$.equals(option3)) {
                        return trigger.withEarlyFirings(early);
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option4 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                    Some some = (Some)option4;
                    Trigger late = (Trigger)some.value();
                    return trigger.withLateFirings(late);
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option5 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option5)) {
                    return trigger;
                }
            }
            throw new MatchError((Object)tuple2);
        }
        ProcessingTimeTriggers.AfterEndOfWindow trigger = ProcessingTimeTriggers.afterEndOfWindow();
        Option<Trigger<TimeWindow>> option = earlyTrigger;
        if (option instanceof Some) {
            Some some = (Some)option;
            Trigger early = (Trigger)some.value();
            return trigger.withEarlyFirings(early);
        }
        if (None$.MODULE$.equals(option)) {
            return trigger;
        }
        throw new MatchError(option);
    }

    public String toString() {
        BoxedUnit boxedUnit;
        scala.collection.mutable.StringBuilder builder = new scala.collection.mutable.StringBuilder();
        String earlyString = this.fireDelayToString(this.earlyFireDelayEnabled, this.earlyFireDelay);
        String lateString = this.fireDelayToString(this.lateFireDelayEnabled, this.lateFireDelay);
        Object object = earlyString != null ? builder.append("early ").append(earlyString) : BoxedUnit.UNIT;
        if (lateString != null) {
            Object object2 = earlyString != null ? builder.append(", ") : BoxedUnit.UNIT;
            boxedUnit = builder.append("late ").append(lateString);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return builder.toString();
    }

    private Option<Trigger<TimeWindow>> createTriggerFromFireDelay(Boolean enableDelayEmit, Duration fireDelay) {
        if (!Predef$.MODULE$.Boolean2boolean(enableDelayEmit)) {
            return None$.MODULE$;
        }
        if (fireDelay.toMillis() > 0L) {
            return new Some((Object)ProcessingTimeTriggers.every((Duration)fireDelay));
        }
        return new Some((Object)ElementTriggers.every());
    }

    private String fireDelayToString(Boolean enableDelayEmit, Duration fireDelay) {
        if (!Predef$.MODULE$.Boolean2boolean(enableDelayEmit)) {
            return null;
        }
        if (fireDelay.toMillis() > 0L) {
            return new StringBuilder(18).append("delay ").append(fireDelay.toMillis()).append(" millisecond").toString();
        }
        return "no delay";
    }

    public WindowEmitStrategy(Boolean isEventTime, Boolean isSessionWindow, Duration earlyFireDelay, Boolean earlyFireDelayEnabled, Duration lateFireDelay, Boolean lateFireDelayEnabled, Long allowLateness) {
        this.isEventTime = isEventTime;
        this.isSessionWindow = isSessionWindow;
        this.earlyFireDelay = earlyFireDelay;
        this.earlyFireDelayEnabled = earlyFireDelayEnabled;
        this.lateFireDelay = lateFireDelay;
        this.lateFireDelayEnabled = lateFireDelayEnabled;
        this.allowLateness = allowLateness;
        this.checkValidation();
    }
}

