/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.flink.sql.parser.ddl.SqlDistribution;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;

public class OperationConverterUtils {
    private OperationConverterUtils() {
    }

    @Nullable
    public static String getComment(SqlTableColumn column) {
        return column.getComment().map(SqlCharStringLiteral.class::cast).map(c -> c.getValueAs(String.class)).orElse(null);
    }

    @Nullable
    public static String getComment(Optional<SqlCharStringLiteral> tableComment) {
        return tableComment.map(comment -> comment.getValueAs(String.class)).orElse(null);
    }

    public static Map<String, String> getProperties(SqlNodeList propList) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (propList != null) {
            propList.getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        }
        return properties;
    }

    public static List<String> getColumnNames(SqlNodeList sqlNodeList) {
        return sqlNodeList.getList().stream().map(p -> ((SqlIdentifier)p).getSimple()).collect(Collectors.toList());
    }

    public static TableDistribution getDistributionFromSqlDistribution(SqlDistribution distribution) {
        TableDistribution.Kind kind = TableDistribution.Kind.valueOf((String)distribution.getDistributionKind().orElse(TableDistribution.Kind.UNKNOWN.toString()));
        Integer bucketCount = null;
        SqlNumericLiteral count = distribution.getBucketCount();
        if (count != null && count.isInteger()) {
            bucketCount = ((BigDecimal)count.getValue()).intValue();
        }
        List bucketColumns = Collections.emptyList();
        SqlNodeList columns = distribution.getBucketColumns();
        if (columns != null) {
            bucketColumns = columns.getList().stream().map(p -> ((SqlIdentifier)p).getSimple()).collect(Collectors.toList());
        }
        return TableDistribution.of((TableDistribution.Kind)kind, (Integer)bucketCount, bucketColumns);
    }

    public static String getQuotedSqlString(SqlNode sqlNode, FlinkPlannerImpl flinkPlanner) {
        SqlParser.Config parserConfig = flinkPlanner.config().getParserConfig();
        CalciteSqlDialect dialect = new CalciteSqlDialect(SqlDialect.EMPTY_CONTEXT.withQuotedCasing(parserConfig.unquotedCasing()).withConformance(parserConfig.conformance()).withUnquotedCasing(parserConfig.unquotedCasing()).withIdentifierQuoteString(parserConfig.quoting().string));
        return sqlNode.toSqlString(dialect).getSql();
    }
}

