/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.resolver.rules.RuleExpressionVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;

@Internal
final class QualifyBuiltInFunctionsRule
implements ResolverRule {
    QualifyBuiltInFunctionsRule() {
    }

    @Override
    public List<Expression> apply(List<Expression> expression, ResolverRule.ResolutionContext context) {
        return expression.stream().map(expr -> expr.accept(new QualifyBuiltInFunctionVisitor(context))).collect(Collectors.toList());
    }

    private static class QualifyBuiltInFunctionVisitor
    extends RuleExpressionVisitor<Expression> {
        QualifyBuiltInFunctionVisitor(ResolverRule.ResolutionContext resolutionContext) {
            super(resolutionContext);
        }

        @Override
        public Expression visit(UnresolvedCallExpression unresolvedCall) {
            FunctionDefinition definition = unresolvedCall.getFunctionDefinition();
            List<Expression> args = unresolvedCall.getChildren().stream().map(c -> c.accept(this)).collect(Collectors.toList());
            if (!unresolvedCall.getFunctionIdentifier().isPresent() && definition instanceof BuiltInFunctionDefinition) {
                ContextResolvedFunction resolvedFunction = this.resolutionContext.functionLookup().lookupBuiltInFunction((BuiltInFunctionDefinition)unresolvedCall.getFunctionDefinition());
                return ApiExpressionUtils.unresolvedCall(resolvedFunction, args);
            }
            return unresolvedCall.replaceArgs(args);
        }

        @Override
        protected Expression defaultMethod(Expression expression) {
            return expression;
        }
    }
}

