/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.CallSyntaxUtils;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.utils.EncodingUtils;

@Internal
public interface SqlCallSyntax {
    public static final SqlCallSyntax FUNCTION = new SqlCallSyntax(){

        @Override
        public String unparse(String sqlName, List<ResolvedExpression> operands, SqlFactory sqlFactory) {
            return this.doUnParse(sqlName, operands, false, sqlFactory);
        }

        @Override
        public String unparseDistinct(String sqlName, List<ResolvedExpression> operands, SqlFactory sqlFactory) {
            return this.doUnParse(sqlName, operands, true, sqlFactory);
        }

        private String doUnParse(String sqlName, List<ResolvedExpression> operands, boolean isDistinct, SqlFactory sqlFactory) {
            return String.format("%s(%s%s)", sqlName, isDistinct ? "DISTINCT " : "", operands.stream().map(resolvedExpression -> resolvedExpression.asSerializableString(sqlFactory)).collect(Collectors.joining(", ")));
        }
    };
    public static final SqlCallSyntax NO_PARENTHESIS = (sqlName, operands, sqlFactory) -> sqlName;
    public static final SqlCallSyntax DISTINCT = (sqlName, operands, sqlFactory) -> {
        CallExpression callExpression = (CallExpression)operands.get(0);
        if (callExpression.getFunctionDefinition() instanceof BuiltInFunctionDefinition) {
            BuiltInFunctionDefinition builtinDefinition = (BuiltInFunctionDefinition)callExpression.getFunctionDefinition();
            return builtinDefinition.getCallSyntax().unparseDistinct(builtinDefinition.getSqlName(), callExpression.getResolvedChildren(), sqlFactory);
        }
        return FUNCTION.unparseDistinct(callExpression.getFunctionName(), callExpression.getResolvedChildren(), sqlFactory);
    };
    public static final SqlCallSyntax COLLECTION_CTOR = (sqlName, operands, sqlFactory) -> String.format("%s[%s]", sqlName, operands.stream().map(resolvedExpression -> resolvedExpression.asSerializableString(sqlFactory)).collect(Collectors.joining(", ")));
    public static final SqlCallSyntax BINARY_OP = (sqlName, operands, sqlFactory) -> String.format("%s %s %s", CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(0), sqlFactory), sqlName, CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(1), sqlFactory));
    public static final SqlCallSyntax PLUS_OP = (sqlName, operands, sqlFactory) -> {
        boolean isString = operands.stream().anyMatch(op -> op.getOutputDataType().getLogicalType().is(LogicalTypeFamily.CHARACTER_STRING));
        if (isString) {
            return FUNCTION.unparse(BuiltInFunctionDefinitions.CONCAT.getSqlName(), operands, sqlFactory);
        }
        return BINARY_OP.unparse(sqlName, operands, sqlFactory);
    };
    public static final SqlCallSyntax MULTIPLE_BINARY_OP = (sqlName, operands, sqlFactory) -> operands.stream().map(expression -> CallSyntaxUtils.asSerializableOperand(expression, sqlFactory)).collect(Collectors.joining(String.format(" %s ", sqlName)));
    public static final SqlCallSyntax UNARY_SUFFIX_OP = (sqlName, operands, sqlFactory) -> String.format("%s %s", CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(0), sqlFactory), sqlName);
    public static final SqlCallSyntax UNARY_PREFIX_OP = (sqlName, operands, sqlFactory) -> String.format("%s %s", sqlName, CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(0), sqlFactory));
    public static final SqlCallSyntax CAST = (sqlName, operands, sqlFactory) -> String.format("%s(%s AS %s)", sqlName, ((ResolvedExpression)operands.get(0)).asSerializableString(sqlFactory), ((ResolvedExpression)operands.get(1)).asSerializableString(sqlFactory));
    public static final SqlCallSyntax SUBSTRING = (sqlName, operands, sqlFactory) -> {
        String s = String.format("%s(%s FROM %s", sqlName, ((ResolvedExpression)operands.get(0)).asSerializableString(sqlFactory), ((ResolvedExpression)operands.get(1)).asSerializableString(sqlFactory));
        if (operands.size() == 3) {
            return s + String.format(" FOR %s)", ((ResolvedExpression)operands.get(2)).asSerializableString(sqlFactory));
        }
        return s + ")";
    };
    public static final SqlCallSyntax FLOOR_OR_CEIL = (sqlName, operands, sqlFactory) -> {
        if (operands.size() == 1) {
            return FUNCTION.unparse(sqlName, operands, sqlFactory);
        }
        return String.format("%s(%s TO %s)", sqlName, ((ResolvedExpression)operands.get(0)).asSerializableString(sqlFactory), ((ValueLiteralExpression)operands.get(1)).getValueAs(TimeIntervalUnit.class).get());
    };
    public static final SqlCallSyntax TRIM = (sqlName, operands, sqlFactory) -> {
        boolean trimLeading = ((ValueLiteralExpression)operands.get(0)).getValueAs(Boolean.class).get();
        boolean trimTrailing = ((ValueLiteralExpression)operands.get(1)).getValueAs(Boolean.class).get();
        String format = trimLeading && trimTrailing ? "TRIM(BOTH %s FROM %s)" : (trimLeading ? "TRIM(LEADING %s FROM %s)" : (trimTrailing ? "TRIM(TRAILING %s FROM %s)" : "TRIM(%s FROM %s)"));
        return String.format(format, ((ResolvedExpression)operands.get(2)).asSerializableString(sqlFactory), ((ResolvedExpression)operands.get(3)).asSerializableString(sqlFactory));
    };
    public static final SqlCallSyntax OVERLAY = (sqlName, operands, sqlFactory) -> {
        String s = String.format("OVERLAY(%s PLACING %s FROM %s", ((ResolvedExpression)operands.get(0)).asSerializableString(sqlFactory), ((ResolvedExpression)operands.get(1)).asSerializableString(sqlFactory), ((ResolvedExpression)operands.get(2)).asSerializableString(sqlFactory));
        if (operands.size() == 4) {
            return s + String.format(" FOR %s)", ((ResolvedExpression)operands.get(3)).asSerializableString(sqlFactory));
        }
        return s + ")";
    };
    public static final SqlCallSyntax AS = (sqlName, operands, sqlFactory) -> {
        if (operands.size() != 2) {
            throw new TableException("The AS function with multiple aliases is not SQL serializable. It should've been flattened during expression resolution.");
        }
        String identifier = ExpressionUtils.stringValue((Expression)operands.get(1));
        return String.format("%s %s %s", CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(0), sqlFactory), sqlName, EncodingUtils.escapeIdentifier(identifier));
    };
    public static final SqlCallSyntax IN = (sqlName, operands, sqlFactory) -> String.format("%s IN (%s)", ((ResolvedExpression)operands.get(0)).asSerializableString(sqlFactory), operands.subList(1, operands.size()).stream().map(resolvedExpression -> resolvedExpression.asSerializableString(sqlFactory)).collect(Collectors.joining(", ")));
    public static final SqlCallSyntax WINDOW_START_END = (sqlName, operands, sqlFactory) -> String.format("%s", sqlName);
    public static final SqlCallSyntax LIKE = (sqlName, operands, sqlFactory) -> {
        if (operands.size() == 2) {
            return String.format("%s %s %s", CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(0), sqlFactory), sqlName, CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(1), sqlFactory));
        }
        return String.format("%s %s %s ESCAPE %s", CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(0), sqlFactory), sqlName, CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(1), sqlFactory), CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(2), sqlFactory));
    };
    public static final SqlCallSyntax OVER = (sqlName, operands, sqlFactory) -> {
        String projection = ((ResolvedExpression)operands.get(0)).asSerializableString(sqlFactory);
        String order = ((ResolvedExpression)operands.get(1)).asSerializableString(sqlFactory);
        String rangeBounds = CallSyntaxUtils.overRangeToSerializableString((ResolvedExpression)operands.get(2), (ResolvedExpression)operands.get(3), sqlFactory);
        if (operands.size() == 4) {
            return String.format("%s OVER(ORDER BY %s%s)", projection, order, rangeBounds);
        }
        return String.format("%s OVER(PARTITION BY %s ORDER BY %s%s)", projection, CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(4), sqlFactory), order, rangeBounds);
    };

    public String unparse(String var1, List<ResolvedExpression> var2, SqlFactory var3);

    default public String unparseDistinct(String sqlName, List<ResolvedExpression> operands, SqlFactory sqlFactory) {
        throw new UnsupportedOperationException("Only the FUNCTION syntax supports the DISTINCT clause.");
    }
}

