/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;

@Internal
class CastInputTypeStrategy
implements InputTypeStrategy {
    CastInputTypeStrategy() {
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return ConstantArgumentCount.of(2);
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        if (!callContext.isArgumentLiteral(1) || !callContext.getArgumentValue(1, DataType.class).isPresent()) {
            return Optional.empty();
        }
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        LogicalType fromType = argumentDataTypes.get(0).getLogicalType();
        LogicalType toType = argumentDataTypes.get(1).getLogicalType();
        if (fromType instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes);
        }
        if (!LogicalTypeCasts.supportsExplicitCast(fromType, toType)) {
            return callContext.fail(throwOnFailure, "Unsupported cast from '%s' to '%s'.", fromType, toType);
        }
        return Optional.of(argumentDataTypes);
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return Collections.singletonList(Signature.of(Signature.Argument.ofGroup("ANY"), Signature.Argument.ofGroup("TYPE LITERAL")));
    }
}

