/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream;

import java.util.Iterator;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.stream.AbstractStreamingJoinOperator;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinRecordStateView;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinRecordStateViews;
import org.apache.flink.table.runtime.operators.join.stream.state.OuterJoinRecordStateView;
import org.apache.flink.table.runtime.operators.join.stream.state.OuterJoinRecordStateViews;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinInputSideSpec;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.types.RowKind;

public class StreamingJoinOperator
extends AbstractStreamingJoinOperator {
    private static final long serialVersionUID = -376944622236540545L;
    protected final boolean leftIsOuter;
    protected final boolean rightIsOuter;
    private transient JoinedRowData outRow;
    private transient RowData leftNullRow;
    private transient RowData rightNullRow;
    protected transient JoinRecordStateView leftRecordStateView;
    protected transient JoinRecordStateView rightRecordStateView;

    public StreamingJoinOperator(InternalTypeInfo<RowData> leftType, InternalTypeInfo<RowData> rightType, GeneratedJoinCondition generatedJoinCondition, JoinInputSideSpec leftInputSideSpec, JoinInputSideSpec rightInputSideSpec, boolean leftIsOuter, boolean rightIsOuter, boolean[] filterNullKeys, long leftStateRetentionTime, long rightStateRetentionTime) {
        super(leftType, rightType, generatedJoinCondition, leftInputSideSpec, rightInputSideSpec, filterNullKeys, leftStateRetentionTime, rightStateRetentionTime);
        this.leftIsOuter = leftIsOuter;
        this.rightIsOuter = rightIsOuter;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.outRow = new JoinedRowData();
        this.leftNullRow = new GenericRowData(this.leftType.toRowSize());
        this.rightNullRow = new GenericRowData(this.rightType.toRowSize());
        this.leftRecordStateView = this.leftIsOuter ? OuterJoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "left-records", this.leftInputSideSpec, this.leftType, this.leftStateRetentionTime) : JoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "left-records", this.leftInputSideSpec, this.leftType, this.leftStateRetentionTime);
        this.rightRecordStateView = this.rightIsOuter ? OuterJoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "right-records", this.rightInputSideSpec, this.rightType, this.rightStateRetentionTime) : JoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "right-records", this.rightInputSideSpec, this.rightType, this.rightStateRetentionTime);
    }

    public void processElement1(StreamRecord<RowData> element) throws Exception {
        this.processElement((RowData)element.getValue(), this.leftRecordStateView, this.rightRecordStateView, true, false);
    }

    public void processElement2(StreamRecord<RowData> element) throws Exception {
        this.processElement((RowData)element.getValue(), this.rightRecordStateView, this.leftRecordStateView, false, false);
    }

    protected void processElement(RowData input, JoinRecordStateView inputSideStateView, JoinRecordStateView otherSideStateView, boolean inputIsLeft, boolean isSuppress) throws Exception {
        block16: {
            Iterator<AbstractStreamingJoinOperator.OuterRecord> associatedRecords;
            RowKind inputRowKind;
            boolean otherIsOuter;
            boolean inputIsOuter;
            block17: {
                block14: {
                    block15: {
                        inputIsOuter = inputIsLeft ? this.leftIsOuter : this.rightIsOuter;
                        otherIsOuter = inputIsLeft ? this.rightIsOuter : this.leftIsOuter;
                        boolean isAccumulateMsg = RowDataUtil.isAccumulateMsg(input);
                        inputRowKind = input.getRowKind();
                        input.setRowKind(RowKind.INSERT);
                        if (!isAccumulateMsg) break block14;
                        if (!inputIsOuter) break block15;
                        Iterator<AbstractStreamingJoinOperator.OuterRecord> associatedRecords2 = AbstractStreamingJoinOperator.iterator(input, inputIsLeft, otherSideStateView, this.joinCondition);
                        if (!associatedRecords2.hasNext()) {
                            this.outRow.setRowKind(RowKind.INSERT);
                            this.outputNullPadding(input, inputIsLeft);
                            ((OuterJoinRecordStateView)inputSideStateView).addRecord(input, 0);
                            return;
                        }
                        int numAssociations = 0;
                        while (associatedRecords2.hasNext()) {
                            AbstractStreamingJoinOperator.OuterRecord outerRecord = associatedRecords2.next();
                            RowData other = outerRecord.record;
                            if (otherIsOuter) {
                                if (outerRecord.numOfAssociations == 0 && !isSuppress) {
                                    this.outRow.setRowKind(RowKind.DELETE);
                                    this.outputNullPadding(other, !inputIsLeft);
                                }
                                ((OuterJoinRecordStateView)otherSideStateView).updateNumOfAssociations(other, outerRecord.numOfAssociations + 1);
                            }
                            this.outRow.setRowKind(RowKind.INSERT);
                            this.output(input, other, inputIsLeft);
                            ++numAssociations;
                        }
                        ((OuterJoinRecordStateView)inputSideStateView).addRecord(input, numAssociations);
                        break block16;
                    }
                    inputSideStateView.addRecord(input);
                    Iterator<AbstractStreamingJoinOperator.OuterRecord> associatedRecords3 = AbstractStreamingJoinOperator.iterator(input, inputIsLeft, otherSideStateView, this.joinCondition);
                    if (!associatedRecords3.hasNext()) break block16;
                    if (otherIsOuter) {
                        OuterJoinRecordStateView otherSideOuterStateView = (OuterJoinRecordStateView)otherSideStateView;
                        while (associatedRecords3.hasNext()) {
                            AbstractStreamingJoinOperator.OuterRecord outerRecord = associatedRecords3.next();
                            if (outerRecord.numOfAssociations == 0 && !isSuppress) {
                                this.outRow.setRowKind(RowKind.DELETE);
                                this.outputNullPadding(outerRecord.record, !inputIsLeft);
                            }
                            otherSideOuterStateView.updateNumOfAssociations(outerRecord.record, outerRecord.numOfAssociations + 1);
                            this.outRow.setRowKind(RowKind.INSERT);
                            this.output(input, outerRecord.record, inputIsLeft);
                        }
                    } else {
                        this.outRow.setRowKind(inputRowKind);
                        while (associatedRecords3.hasNext()) {
                            AbstractStreamingJoinOperator.OuterRecord other = associatedRecords3.next();
                            this.output(input, other.record, inputIsLeft);
                        }
                    }
                    break block16;
                }
                if (!isSuppress) {
                    inputSideStateView.retractRecord(input);
                }
                if ((associatedRecords = AbstractStreamingJoinOperator.iterator(input, inputIsLeft, otherSideStateView, this.joinCondition)).hasNext()) break block17;
                if (!inputIsOuter) break block16;
                this.outRow.setRowKind(RowKind.DELETE);
                this.outputNullPadding(input, inputIsLeft);
                break block16;
            }
            while (associatedRecords.hasNext()) {
                if (inputIsOuter) {
                    this.outRow.setRowKind(RowKind.DELETE);
                } else {
                    this.outRow.setRowKind(inputRowKind);
                }
                AbstractStreamingJoinOperator.OuterRecord outerRecord = associatedRecords.next();
                this.output(input, outerRecord.record, inputIsLeft);
                if (!otherIsOuter) continue;
                OuterJoinRecordStateView otherSideOuterStateView = (OuterJoinRecordStateView)otherSideStateView;
                if (outerRecord.numOfAssociations == 1 && !isSuppress) {
                    this.outRow.setRowKind(RowKind.INSERT);
                    this.outputNullPadding(outerRecord.record, !inputIsLeft);
                }
                otherSideOuterStateView.updateNumOfAssociations(outerRecord.record, outerRecord.numOfAssociations - 1);
            }
        }
    }

    private void output(RowData inputRow, RowData otherRow, boolean inputIsLeft) {
        if (inputIsLeft) {
            this.outRow.replace(inputRow, otherRow);
        } else {
            this.outRow.replace(otherRow, inputRow);
        }
        this.collector.collect((Object)this.outRow);
    }

    private void outputNullPadding(RowData row, boolean isLeft) {
        if (isLeft) {
            this.outRow.replace(row, this.rightNullRow);
        } else {
            this.outRow.replace(this.leftNullRow, row);
        }
        this.collector.collect((Object)this.outRow);
    }
}

