/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.util.Preconditions;

abstract class AbstractMapTypeInfo<K, V, M extends Map<K, V>>
extends TypeInformation<M> {
    private static final long serialVersionUID = 1L;
    final TypeInformation<K> keyTypeInfo;
    final TypeInformation<V> valueTypeInfo;

    AbstractMapTypeInfo(TypeInformation<K> keyTypeInfo, TypeInformation<V> valueTypeInfo) {
        Preconditions.checkNotNull(keyTypeInfo, (String)"The type information for the keys cannot be null.");
        Preconditions.checkNotNull(valueTypeInfo, (String)"The type information for the values cannot be null.");
        this.keyTypeInfo = keyTypeInfo;
        this.valueTypeInfo = valueTypeInfo;
    }

    AbstractMapTypeInfo(Class<K> keyClass, Class<V> valueClass) {
        Preconditions.checkNotNull(keyClass, (String)"The key class cannot be null.");
        Preconditions.checkNotNull(valueClass, (String)"The value class cannot be null.");
        this.keyTypeInfo = TypeInformation.of(keyClass);
        this.valueTypeInfo = TypeInformation.of(valueClass);
    }

    public TypeInformation<K> getKeyTypeInfo() {
        return this.keyTypeInfo;
    }

    public TypeInformation<V> getValueTypeInfo() {
        return this.valueTypeInfo;
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 0;
    }

    public int getTotalFields() {
        return 2;
    }

    public boolean isKeyType() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AbstractMapTypeInfo that = (AbstractMapTypeInfo)((Object)o);
        return this.keyTypeInfo.equals(that.keyTypeInfo) && this.valueTypeInfo.equals(that.valueTypeInfo);
    }

    public int hashCode() {
        int result = this.keyTypeInfo.hashCode();
        result = 31 * result + this.valueTypeInfo.hashCode();
        return result;
    }
}

