/*
 * Decompiled with CFR 0.152.
 */
package io.github.ollama4j.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;

public class Utils {
    private static ObjectMapper objectMapper;

    public static ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            objectMapper.registerModule(new JavaTimeModule());
        }
        return objectMapper;
    }

    public static byte[] loadImageBytesFromUrl(String imageUrl) throws IOException, URISyntaxException {
        URL url = new URI(imageUrl).toURL();
        try (InputStream in = url.openStream();){
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    public static File getFileFromClasspath(String fileName) {
        ClassLoader classLoader = Utils.class.getClassLoader();
        return new File(Objects.requireNonNull(classLoader.getResource(fileName)).getFile());
    }
}

