/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.dataset.substrait;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.arrow.c.ArrowArrayStream;
import org.apache.arrow.c.Data;
import org.apache.arrow.dataset.substrait.JniWrapper;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.ipc.ArrowReader;

public final class AceroSubstraitConsumer {
    private final BufferAllocator allocator;

    public AceroSubstraitConsumer(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    public ArrowReader runQuery(String plan) throws Exception {
        return this.runQuery(plan, Collections.emptyMap());
    }

    public ArrowReader runQuery(String plan, Map<String, ArrowReader> namedTables) throws Exception {
        return this.execute(plan, namedTables);
    }

    public ArrowReader runQuery(ByteBuffer plan) throws Exception {
        return this.runQuery(plan, Collections.emptyMap());
    }

    public ArrowReader runQuery(ByteBuffer plan, Map<String, ArrowReader> namedTables) throws Exception {
        return this.execute(plan, namedTables);
    }

    /*
     * Loose catch block
     */
    private ArrowReader execute(String plan, Map<String, ArrowReader> namedTables) throws Exception {
        ArrayList<ArrowArrayStream> arrowArrayStream = new ArrayList<ArrowArrayStream>();
        try {
            try (ArrowArrayStream streamOutput = ArrowArrayStream.allocateNew((BufferAllocator)this.allocator);){
                String[] mapTableToMemoryAddress = this.getMapTableToMemoryAddress(namedTables, arrowArrayStream);
                JniWrapper.get().executeSerializedPlan(plan, mapTableToMemoryAddress, streamOutput.memoryAddress());
                ArrowReader arrowReader = Data.importArrayStream((BufferAllocator)this.allocator, (ArrowArrayStream)streamOutput);
                return arrowReader;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            AutoCloseables.close(arrowArrayStream);
        }
    }

    /*
     * Loose catch block
     */
    private ArrowReader execute(ByteBuffer plan, Map<String, ArrowReader> namedTables) throws Exception {
        ArrayList<ArrowArrayStream> arrowArrayStream = new ArrayList<ArrowArrayStream>();
        try {
            try (ArrowArrayStream streamOutput = ArrowArrayStream.allocateNew((BufferAllocator)this.allocator);){
                String[] mapTableToMemoryAddress = this.getMapTableToMemoryAddress(namedTables, arrowArrayStream);
                JniWrapper.get().executeSerializedPlan(plan, mapTableToMemoryAddress, streamOutput.memoryAddress());
                ArrowReader arrowReader = Data.importArrayStream((BufferAllocator)this.allocator, (ArrowArrayStream)streamOutput);
                return arrowReader;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            AutoCloseables.close(arrowArrayStream);
        }
    }

    private String[] getMapTableToMemoryAddress(Map<String, ArrowReader> mapTableToArrowReader, List<ArrowArrayStream> listStreamInput) {
        String[] mapTableToMemoryAddress = new String[mapTableToArrowReader.size() * 2];
        int pos = 0;
        for (Map.Entry<String, ArrowReader> entries : mapTableToArrowReader.entrySet()) {
            ArrowArrayStream streamInput = ArrowArrayStream.allocateNew((BufferAllocator)this.allocator);
            listStreamInput.add(streamInput);
            Data.exportArrayStream((BufferAllocator)this.allocator, (ArrowReader)entries.getValue(), (ArrowArrayStream)streamInput);
            mapTableToMemoryAddress[pos] = entries.getKey();
            mapTableToMemoryAddress[pos + 1] = String.valueOf(streamInput.memoryAddress());
            pos += 2;
        }
        return mapTableToMemoryAddress;
    }
}

