/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.paimon.types.DataType;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="action")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SetOption.class, name="setOption"), @JsonSubTypes.Type(value=RemoveOption.class, name="removeOption"), @JsonSubTypes.Type(value=UpdateComment.class, name="updateComment"), @JsonSubTypes.Type(value=AddColumn.class, name="addColumn"), @JsonSubTypes.Type(value=RenameColumn.class, name="renameColumn"), @JsonSubTypes.Type(value=DropColumn.class, name="dropColumn"), @JsonSubTypes.Type(value=UpdateColumnType.class, name="updateColumnType"), @JsonSubTypes.Type(value=UpdateColumnNullability.class, name="updateColumnNullability"), @JsonSubTypes.Type(value=UpdateColumnComment.class, name="updateColumnComment"), @JsonSubTypes.Type(value=UpdateColumnDefaultValue.class, name="updateColumnDefaultValue"), @JsonSubTypes.Type(value=UpdateColumnPosition.class, name="updateColumnPosition")})
@Public
public interface SchemaChange
extends Serializable {
    public static SchemaChange setOption(String key, String value) {
        return new SetOption(key, value);
    }

    public static SchemaChange removeOption(String key) {
        return new RemoveOption(key);
    }

    public static SchemaChange updateComment(@Nullable String comment) {
        return new UpdateComment(comment);
    }

    public static SchemaChange addColumn(String fieldName, DataType dataType) {
        return SchemaChange.addColumn(fieldName, dataType, null, null);
    }

    public static SchemaChange addColumn(String fieldName, DataType dataType, String comment) {
        return new AddColumn(new String[]{fieldName}, dataType, comment, null);
    }

    public static SchemaChange addColumn(String fieldName, DataType dataType, String comment, Move move) {
        return new AddColumn(new String[]{fieldName}, dataType, comment, move);
    }

    public static SchemaChange addColumn(String[] fieldNames, DataType dataType, String comment, Move move) {
        return new AddColumn(fieldNames, dataType, comment, move);
    }

    public static SchemaChange renameColumn(String fieldName, String newName) {
        return new RenameColumn(new String[]{fieldName}, newName);
    }

    public static SchemaChange renameColumn(String[] fieldNames, String newName) {
        return new RenameColumn(fieldNames, newName);
    }

    public static SchemaChange dropColumn(String fieldName) {
        return new DropColumn(new String[]{fieldName});
    }

    public static SchemaChange dropColumn(String[] fieldNames) {
        return new DropColumn(fieldNames);
    }

    public static SchemaChange updateColumnType(String fieldName, DataType newDataType) {
        return new UpdateColumnType(new String[]{fieldName}, newDataType, false);
    }

    public static SchemaChange updateColumnType(String fieldName, DataType newDataType, boolean keepNullability) {
        return new UpdateColumnType(new String[]{fieldName}, newDataType, keepNullability);
    }

    public static SchemaChange updateColumnType(String[] fieldNames, DataType newDataType, boolean keepNullability) {
        return new UpdateColumnType(fieldNames, newDataType, keepNullability);
    }

    public static SchemaChange updateColumnNullability(String fieldName, boolean newNullability) {
        return new UpdateColumnNullability(new String[]{fieldName}, newNullability);
    }

    public static SchemaChange updateColumnNullability(String[] fieldNames, boolean newNullability) {
        return new UpdateColumnNullability(fieldNames, newNullability);
    }

    public static SchemaChange updateColumnComment(String fieldName, String comment) {
        return new UpdateColumnComment(new String[]{fieldName}, comment);
    }

    public static SchemaChange updateColumnComment(String[] fieldNames, String comment) {
        return new UpdateColumnComment(fieldNames, comment);
    }

    public static SchemaChange updateColumnDefaultValue(String[] fieldNames, String defaultValue) {
        return new UpdateColumnDefaultValue(fieldNames, defaultValue);
    }

    public static SchemaChange updateColumnPosition(Move move) {
        return new UpdateColumnPosition(move);
    }

    public static class Actions {
        public static final String FIELD_ACTION = "action";
        public static final String SET_OPTION_ACTION = "setOption";
        public static final String REMOVE_OPTION_ACTION = "removeOption";
        public static final String UPDATE_COMMENT_ACTION = "updateComment";
        public static final String ADD_COLUMN_ACTION = "addColumn";
        public static final String RENAME_COLUMN_ACTION = "renameColumn";
        public static final String DROP_COLUMN_ACTION = "dropColumn";
        public static final String UPDATE_COLUMN_TYPE_ACTION = "updateColumnType";
        public static final String UPDATE_COLUMN_NULLABILITY_ACTION = "updateColumnNullability";
        public static final String UPDATE_COLUMN_COMMENT_ACTION = "updateColumnComment";
        public static final String UPDATE_COLUMN_DEFAULT_VALUE_ACTION = "updateColumnDefaultValue";
        public static final String UPDATE_COLUMN_POSITION_ACTION = "updateColumnPosition";

        private Actions() {
        }
    }

    public static final class UpdateColumnDefaultValue
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_FILED_NAMES = "fieldNames";
        private static final String FIELD_NEW_DEFAULT_VALUE = "newDefaultValue";
        @JsonProperty(value="fieldNames")
        private final String[] fieldNames;
        @JsonProperty(value="newDefaultValue")
        private final String newDefaultValue;

        @JsonCreator
        private UpdateColumnDefaultValue(@JsonProperty(value="fieldNames") String[] fieldNames, @JsonProperty(value="newDefaultValue") String newDefaultValue) {
            this.fieldNames = fieldNames;
            this.newDefaultValue = newDefaultValue;
        }

        @JsonGetter(value="fieldNames")
        public String[] fieldNames() {
            return this.fieldNames;
        }

        @JsonGetter(value="newDefaultValue")
        public String newDefaultValue() {
            return this.newDefaultValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnDefaultValue that = (UpdateColumnDefaultValue)o;
            return Arrays.equals(this.fieldNames, that.fieldNames) && this.newDefaultValue.equals(that.newDefaultValue);
        }

        public int hashCode() {
            int result = Objects.hash(this.newDefaultValue);
            result = 31 * result + Objects.hashCode(this.fieldNames);
            return result;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class UpdateColumnComment
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_FILED_NAMES = "fieldNames";
        private static final String FIELD_NEW_COMMENT = "newComment";
        @JsonProperty(value="fieldNames")
        private final String[] fieldNames;
        @JsonProperty(value="newComment")
        private final String newDescription;

        @JsonCreator
        public UpdateColumnComment(@JsonProperty(value="fieldNames") String[] fieldNames, @JsonProperty(value="newComment") String newDescription) {
            this.fieldNames = fieldNames;
            this.newDescription = newDescription;
        }

        @JsonGetter(value="fieldNames")
        public String[] fieldNames() {
            return this.fieldNames;
        }

        @JsonGetter(value="newComment")
        public String newDescription() {
            return this.newDescription;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UpdateColumnComment)) {
                return false;
            }
            UpdateColumnComment that = (UpdateColumnComment)o;
            return Arrays.equals(this.fieldNames, that.fieldNames) && this.newDescription.equals(that.newDescription);
        }

        public int hashCode() {
            int result = Objects.hash(this.newDescription);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class UpdateColumnNullability
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_FILED_NAMES = "fieldNames";
        private static final String FIELD_NEW_NULLABILITY = "newNullability";
        @JsonProperty(value="fieldNames")
        private final String[] fieldNames;
        @JsonProperty(value="newNullability")
        private final boolean newNullability;

        @JsonCreator
        public UpdateColumnNullability(@JsonProperty(value="fieldNames") String[] fieldNames, @JsonProperty(value="newNullability") boolean newNullability) {
            this.fieldNames = fieldNames;
            this.newNullability = newNullability;
        }

        @JsonGetter(value="fieldNames")
        public String[] fieldNames() {
            return this.fieldNames;
        }

        @JsonGetter(value="newNullability")
        public boolean newNullability() {
            return this.newNullability;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UpdateColumnNullability)) {
                return false;
            }
            UpdateColumnNullability that = (UpdateColumnNullability)o;
            return this.newNullability == that.newNullability && Arrays.equals(this.fieldNames, that.fieldNames);
        }

        public int hashCode() {
            int result = Objects.hash(this.newNullability);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Move
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_FILED_NAME = "fieldName";
        private static final String FIELD_REFERENCE_FIELD_NAME = "referenceFieldName";
        private static final String FIELD_TYPE = "type";
        @JsonProperty(value="fieldName")
        private final String fieldName;
        @JsonProperty(value="referenceFieldName")
        private final String referenceFieldName;
        @JsonProperty(value="type")
        private final MoveType type;

        public static Move first(String fieldName) {
            return new Move(fieldName, null, MoveType.FIRST);
        }

        public static Move after(String fieldName, String referenceFieldName) {
            return new Move(fieldName, referenceFieldName, MoveType.AFTER);
        }

        public static Move before(String fieldName, String referenceFieldName) {
            return new Move(fieldName, referenceFieldName, MoveType.BEFORE);
        }

        public static Move last(String fieldName) {
            return new Move(fieldName, null, MoveType.LAST);
        }

        @JsonCreator
        public Move(@JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="referenceFieldName") String referenceFieldName, @JsonProperty(value="type") MoveType type) {
            this.fieldName = fieldName;
            this.referenceFieldName = referenceFieldName;
            this.type = type;
        }

        @JsonGetter(value="fieldName")
        public String fieldName() {
            return this.fieldName;
        }

        @JsonGetter(value="referenceFieldName")
        public String referenceFieldName() {
            return this.referenceFieldName;
        }

        @JsonGetter(value="type")
        public MoveType type() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Move move = (Move)o;
            return Objects.equals(this.fieldName, move.fieldName) && Objects.equals(this.referenceFieldName, move.referenceFieldName) && Objects.equals((Object)this.type, (Object)move.type);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.fieldName, this.referenceFieldName, this.type});
        }

        public static enum MoveType {
            FIRST,
            AFTER,
            BEFORE,
            LAST;

        }
    }

    public static final class UpdateColumnPosition
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_MOVE = "move";
        @JsonProperty(value="move")
        private final Move move;

        @JsonCreator
        private UpdateColumnPosition(@JsonProperty(value="move") Move move) {
            this.move = move;
        }

        @JsonGetter(value="move")
        public Move move() {
            return this.move;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnPosition updateColumnPosition = (UpdateColumnPosition)o;
            return Objects.equals(this.move, updateColumnPosition.move);
        }

        public int hashCode() {
            return Objects.hash(this.move);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class UpdateColumnType
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_FILED_NAMES = "fieldNames";
        private static final String FIELD_NEW_DATA_TYPE = "newDataType";
        private static final String FIELD_KEEP_NULLABILITY = "keepNullability";
        @JsonProperty(value="fieldNames")
        private final String[] fieldNames;
        @JsonProperty(value="newDataType")
        private final DataType newDataType;
        @JsonProperty(value="keepNullability")
        private final boolean keepNullability;

        @JsonCreator
        private UpdateColumnType(@JsonProperty(value="fieldNames") String[] fieldNames, @JsonProperty(value="newDataType") DataType newDataType, @JsonProperty(value="keepNullability") boolean keepNullability) {
            this.fieldNames = fieldNames;
            this.newDataType = newDataType;
            this.keepNullability = keepNullability;
        }

        @JsonGetter(value="fieldNames")
        public String[] fieldNames() {
            return this.fieldNames;
        }

        @JsonGetter(value="newDataType")
        public DataType newDataType() {
            return this.newDataType;
        }

        @JsonGetter(value="keepNullability")
        public boolean keepNullability() {
            return this.keepNullability;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnType that = (UpdateColumnType)o;
            return Arrays.equals(this.fieldNames, that.fieldNames) && this.newDataType.equals(that.newDataType);
        }

        public int hashCode() {
            int result = Objects.hash(this.newDataType);
            result = 31 * result + Objects.hashCode(this.fieldNames);
            return result;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class DropColumn
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_FILED_NAMES = "fieldNames";
        @JsonProperty(value="fieldNames")
        private final String[] fieldNames;

        @JsonCreator
        private DropColumn(@JsonProperty(value="fieldNames") String[] fieldNames) {
            this.fieldNames = fieldNames;
        }

        @JsonGetter(value="fieldNames")
        public String[] fieldNames() {
            return this.fieldNames;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DropColumn that = (DropColumn)o;
            return Arrays.equals(this.fieldNames, that.fieldNames);
        }

        public int hashCode() {
            return Objects.hashCode(this.fieldNames);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class RenameColumn
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_FILED_NAMES = "fieldNames";
        private static final String FIELD_NEW_NAME = "newName";
        @JsonProperty(value="fieldNames")
        private final String[] fieldNames;
        @JsonProperty(value="newName")
        private final String newName;

        @JsonCreator
        private RenameColumn(@JsonProperty(value="fieldNames") String[] fieldNames, @JsonProperty(value="newName") String newName) {
            this.fieldNames = fieldNames;
            this.newName = newName;
        }

        @JsonGetter(value="fieldNames")
        public String[] fieldNames() {
            return this.fieldNames;
        }

        @JsonGetter(value="newName")
        public String newName() {
            return this.newName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenameColumn that = (RenameColumn)o;
            return Arrays.equals(this.fieldNames, that.fieldNames) && Objects.equals(this.newName, that.newName);
        }

        public int hashCode() {
            int result = Objects.hash(this.newName);
            result = 31 * result + Objects.hashCode(this.fieldNames);
            return result;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class AddColumn
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_FILED_NAMES = "fieldNames";
        private static final String FIELD_DATA_TYPE = "dataType";
        private static final String FIELD_COMMENT = "comment";
        private static final String FIELD_MOVE = "move";
        @JsonProperty(value="fieldNames")
        private final String[] fieldNames;
        @JsonProperty(value="dataType")
        private final DataType dataType;
        @JsonProperty(value="comment")
        private final String description;
        @JsonProperty(value="move")
        private final Move move;

        @JsonCreator
        private AddColumn(@JsonProperty(value="fieldNames") String[] fieldNames, @JsonProperty(value="dataType") DataType dataType, @JsonProperty(value="comment") String description, @JsonProperty(value="move") Move move) {
            this.fieldNames = fieldNames;
            this.dataType = dataType;
            this.description = description;
            this.move = move;
        }

        @JsonGetter(value="fieldNames")
        public String[] fieldNames() {
            return this.fieldNames;
        }

        @JsonGetter(value="dataType")
        public DataType dataType() {
            return this.dataType;
        }

        @Nullable
        @JsonGetter(value="comment")
        public String description() {
            return this.description;
        }

        @Nullable
        @JsonGetter(value="move")
        public Move move() {
            return this.move;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddColumn addColumn = (AddColumn)o;
            return Arrays.equals(this.fieldNames, addColumn.fieldNames) && this.dataType.equals(addColumn.dataType) && Objects.equals(this.description, addColumn.description) && Objects.equals(this.move, addColumn.move);
        }

        public int hashCode() {
            int result = Objects.hash(this.dataType, this.description);
            result = 31 * result + Objects.hashCode(this.fieldNames);
            result = 31 * result + Objects.hashCode(this.move);
            return result;
        }
    }

    public static final class UpdateComment
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_COMMENT = "comment";
        @JsonProperty(value="comment")
        @Nullable
        private final String comment;

        private UpdateComment(@JsonProperty(value="comment") @Nullable String comment) {
            this.comment = comment;
        }

        @JsonGetter(value="comment")
        @Nullable
        public String comment() {
            return this.comment;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            UpdateComment that = (UpdateComment)object;
            return Objects.equals(this.comment, that.comment);
        }

        public int hashCode() {
            return Objects.hash(this.comment);
        }
    }

    public static final class RemoveOption
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_KEY = "key";
        @JsonProperty(value="key")
        private final String key;

        private RemoveOption(@JsonProperty(value="key") String key) {
            this.key = key;
        }

        @JsonGetter(value="key")
        public String key() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveOption that = (RemoveOption)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }

    public static final class SetOption
    implements SchemaChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_KEY = "key";
        private static final String FIELD_VALUE = "value";
        @JsonProperty(value="key")
        private final String key;
        @JsonProperty(value="value")
        private final String value;

        @JsonCreator
        private SetOption(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value) {
            this.key = key;
            this.value = value;
        }

        @JsonGetter(value="key")
        public String key() {
            return this.key;
        }

        @JsonGetter(value="value")
        public String value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetOption that = (SetOption)o;
            return this.key.equals(that.key) && this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }
    }
}

