/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.lookup.ByteArray;
import org.apache.paimon.lookup.SetState;
import org.apache.paimon.lookup.memory.InMemoryState;

public class InMemorySetState<K, V>
extends InMemoryState<K, V>
implements SetState<K, V> {
    private final Map<ByteArray, TreeSet<ByteArray>> values = new HashMap<ByteArray, TreeSet<ByteArray>>();

    public InMemorySetState(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        super(keySerializer, valueSerializer);
    }

    @Override
    public List<V> get(K key) throws IOException {
        Set set = this.values.get(ByteArray.wrapBytes(this.serializeKey(key)));
        ArrayList result = new ArrayList();
        if (set != null) {
            for (ByteArray value : set) {
                result.add(this.deserializeValue(value.bytes));
            }
        }
        return result;
    }

    @Override
    public void retract(K key, V value) throws IOException {
        this.values.get(ByteArray.wrapBytes(this.serializeKey(key))).remove(ByteArray.wrapBytes(this.serializeValue(value)));
    }

    @Override
    public void add(K key, V value) throws IOException {
        byte[] keyBytes = this.serializeKey(key);
        byte[] valueBytes = this.serializeValue(value);
        this.values.computeIfAbsent(ByteArray.wrapBytes(keyBytes), k -> new TreeSet()).add(ByteArray.wrapBytes(valueBytes));
    }
}

