/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.casting.CastElementGetter;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.casting.CastedArray;
import org.apache.paimon.casting.CastedMap;
import org.apache.paimon.casting.CastedRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateReplaceVisitor;
import org.apache.paimon.predicate.PredicateVisitor;
import org.apache.paimon.schema.IndexCastMapping;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.ProjectedRow;

public class SchemaEvolutionUtil {
    private static final int NULL_FIELD_INDEX = -1;

    @Nullable
    public static int[] createIndexMapping(List<DataField> tableFields, List<DataField> dataFields) {
        int i;
        int[] indexMapping = new int[tableFields.size()];
        HashMap<Integer, Integer> fieldIdToIndex = new HashMap<Integer, Integer>();
        for (i = 0; i < dataFields.size(); ++i) {
            fieldIdToIndex.put(dataFields.get(i).id(), i);
        }
        for (i = 0; i < tableFields.size(); ++i) {
            int fieldId = tableFields.get(i).id();
            Integer dataFieldIndex = (Integer)fieldIdToIndex.get(fieldId);
            indexMapping[i] = dataFieldIndex != null ? dataFieldIndex : -1;
        }
        for (i = 0; i < indexMapping.length; ++i) {
            if (indexMapping[i] == i) continue;
            return indexMapping;
        }
        return null;
    }

    public static IndexCastMapping createIndexCastMapping(List<DataField> tableFields, List<DataField> dataFields) {
        final int[] indexMapping = SchemaEvolutionUtil.createIndexMapping(tableFields, dataFields);
        final CastFieldGetter[] castMapping = SchemaEvolutionUtil.createCastFieldGetterMapping(tableFields, dataFields, indexMapping);
        return new IndexCastMapping(){

            @Override
            @Nullable
            public int[] getIndexMapping() {
                return indexMapping;
            }

            @Override
            @Nullable
            public CastFieldGetter[] getCastMapping() {
                return castMapping;
            }
        };
    }

    @Nullable
    public static List<Predicate> devolveDataFilters(List<DataField> tableFields, List<DataField> dataFields, List<Predicate> filters) {
        if (filters == null) {
            return null;
        }
        Map<String, DataField> nameToTableFields = tableFields.stream().collect(Collectors.toMap(DataField::name, f -> f));
        LinkedHashMap idToDataFields = new LinkedHashMap();
        dataFields.forEach(f -> idToDataFields.put(f.id(), f));
        ArrayList<Predicate> dataFilters = new ArrayList<Predicate>(filters.size());
        PredicateReplaceVisitor visitor = predicate -> {
            DataField tableField = (DataField)Preconditions.checkNotNull(nameToTableFields.get(predicate.fieldName()), (String)String.format("Find no field %s", predicate.fieldName()));
            DataField dataField = (DataField)idToDataFields.get(tableField.id());
            if (dataField == null) {
                return Optional.empty();
            }
            return CastExecutors.castLiteralsWithEvolution((List)predicate.literals(), (DataType)predicate.type(), (DataType)dataField.type()).map(literals -> new LeafPredicate(predicate.function(), dataField.type(), SchemaEvolutionUtil.indexOf(dataField, idToDataFields), dataField.name(), literals));
        };
        for (Predicate predicate2 : filters) {
            ((Optional)predicate2.visit((PredicateVisitor)visitor)).ifPresent(dataFilters::add);
        }
        return dataFilters;
    }

    private static int indexOf(DataField dataField, LinkedHashMap<Integer, DataField> dataFields) {
        int index = 0;
        for (Map.Entry<Integer, DataField> entry : dataFields.entrySet()) {
            if (dataField.id() == entry.getKey().intValue()) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException(String.format("Can't find data field %s", dataField.name()));
    }

    private static CastFieldGetter[] createCastFieldGetterMapping(List<DataField> tableFields, List<DataField> dataFields, int[] indexMapping) {
        CastFieldGetter[] converterMapping = new CastFieldGetter[tableFields.size()];
        boolean castExist = false;
        for (int i = 0; i < tableFields.size(); ++i) {
            int dataIndex;
            int n = dataIndex = indexMapping == null ? i : indexMapping[i];
            if (dataIndex < 0) {
                converterMapping[i] = new CastFieldGetter((InternalRow.FieldGetter & Serializable)row -> null, CastExecutors.identityCastExecutor());
                continue;
            }
            DataField tableField = tableFields.get(i);
            DataField dataField = dataFields.get(dataIndex);
            if (!dataField.type().equalsIgnoreNullable(tableField.type())) {
                castExist = true;
            }
            converterMapping[i] = new CastFieldGetter(InternalRowUtils.createNullCheckingFieldGetter((DataType)dataField.type(), (int)i), SchemaEvolutionUtil.createCastExecutor(dataField.type(), tableField.type()));
        }
        return castExist ? converterMapping : null;
    }

    private static CastExecutor<?, ?> createCastExecutor(DataType inputType, DataType targetType) {
        if (targetType.equalsIgnoreNullable(inputType)) {
            return CastExecutors.identityCastExecutor();
        }
        if (inputType instanceof RowType && targetType instanceof RowType) {
            return SchemaEvolutionUtil.createRowCastExecutor((RowType)inputType, (RowType)targetType);
        }
        if (inputType instanceof ArrayType && targetType instanceof ArrayType) {
            return SchemaEvolutionUtil.createArrayCastExecutor((ArrayType)inputType, (ArrayType)targetType);
        }
        if (inputType instanceof MapType && targetType instanceof MapType) {
            return SchemaEvolutionUtil.createMapCastExecutor((MapType)inputType, (MapType)targetType);
        }
        return (CastExecutor)Preconditions.checkNotNull((Object)CastExecutors.resolve((DataType)inputType, (DataType)targetType), (String)"Cannot cast from type %s to type %s", (Object[])new Object[]{inputType, targetType});
    }

    private static CastExecutor<InternalRow, InternalRow> createRowCastExecutor(RowType inputType, RowType targetType) {
        int[] indexMapping = SchemaEvolutionUtil.createIndexMapping(targetType.getFields(), inputType.getFields());
        CastFieldGetter[] castFieldGetters = SchemaEvolutionUtil.createCastFieldGetterMapping(targetType.getFields(), inputType.getFields(), indexMapping);
        ProjectedRow projectedRow = indexMapping == null ? null : ProjectedRow.from((int[])indexMapping);
        CastedRow castedRow = castFieldGetters == null ? null : CastedRow.from((CastFieldGetter[])castFieldGetters);
        return value -> {
            if (projectedRow != null) {
                value = projectedRow.replaceRow(value);
            }
            if (castedRow != null) {
                value = castedRow.replaceRow(value);
            }
            return value;
        };
    }

    private static CastExecutor<InternalArray, InternalArray> createArrayCastExecutor(ArrayType inputType, ArrayType targetType) {
        CastElementGetter castElementGetter = new CastElementGetter(InternalArray.createElementGetter((DataType)inputType.getElementType()), SchemaEvolutionUtil.createCastExecutor(inputType.getElementType(), targetType.getElementType()));
        CastedArray castedArray = CastedArray.from((CastElementGetter)castElementGetter);
        return arg_0 -> ((CastedArray)castedArray).replaceArray(arg_0);
    }

    private static CastExecutor<InternalMap, InternalMap> createMapCastExecutor(MapType inputType, MapType targetType) {
        Preconditions.checkState((boolean)inputType.getKeyType().equals((Object)targetType.getKeyType()), (String)"Cannot cast map type %s to map type %s, because they have different key types.", (Object[])new Object[]{inputType.getKeyType(), targetType.getKeyType()});
        CastElementGetter castElementGetter = new CastElementGetter(InternalArray.createElementGetter((DataType)inputType.getValueType()), SchemaEvolutionUtil.createCastExecutor(inputType.getValueType(), targetType.getValueType()));
        CastedMap castedMap = CastedMap.from((CastElementGetter)castElementGetter);
        return arg_0 -> ((CastedMap)castedMap).replaceMap(arg_0);
    }
}

