/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.ReadPlanStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactedStartingScanner
extends ReadPlanStartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(CompactedStartingScanner.class);

    public CompactedStartingScanner(SnapshotManager snapshotManager) {
        super(snapshotManager);
        this.startingSnapshotId = this.pick();
    }

    @Override
    public ScanMode startingScanMode() {
        return ScanMode.ALL;
    }

    @Override
    public SnapshotReader configure(SnapshotReader snapshotReader) {
        Long startingSnapshotId = this.pick();
        if (startingSnapshotId == null) {
            startingSnapshotId = this.snapshotManager.latestSnapshotId();
            if (startingSnapshotId == null) {
                LOG.debug("There is currently no snapshot. Wait for the snapshot generation.");
                return null;
            }
            LOG.debug("No compact snapshot found, reading from the latest snapshot {}.", (Object)startingSnapshotId);
        }
        return snapshotReader.withMode(ScanMode.ALL).withSnapshot(startingSnapshotId);
    }

    @Nullable
    protected Long pick() {
        return this.snapshotManager.pickOrLatest(s -> s.commitKind() == Snapshot.CommitKind.COMPACT);
    }
}

