/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.info;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.Audit;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.messaging.Topic;

@DeveloperApi
public final class TopicInfo {
    private final String name;
    @Nullable
    private final String comment;
    private final Map<String, String> properties;
    @Nullable
    private final Audit audit;

    public TopicInfo(Topic topic) {
        this(topic.name(), topic.comment(), topic.properties(), topic.auditInfo());
    }

    public TopicInfo(String name, String comment, Map<String, String> properties, Audit audit) {
        this.name = name;
        this.comment = comment;
        this.properties = properties == null ? ImmutableMap.of() : ImmutableMap.copyOf(properties);
        this.audit = audit;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public String comment() {
        return this.comment;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    @Nullable
    public Audit audit() {
        return this.audit;
    }
}

