/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.util.List;
import java.util.function.BiFunction;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.types.VariantType;

public class InternalRowToSizeVisitor
implements DataTypeVisitor<BiFunction<DataGetters, Integer, Integer>> {
    public static final int NULL_SIZE = 0;

    public BiFunction<DataGetters, Integer, Integer> visit(CharType charType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return row.getString((int)index).toBytes().length;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(VarCharType varCharType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return row.getString((int)index).toBytes().length;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(BooleanType booleanType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return 1;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(BinaryType binaryType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return row.getBinary((int)index).length;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(VarBinaryType varBinaryType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return row.getBinary((int)index).length;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(DecimalType decimalType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return row.getDecimal((int)index, decimalType.getPrecision(), decimalType.getScale()).toUnscaledBytes().length;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(TinyIntType tinyIntType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return 1;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(SmallIntType smallIntType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return 2;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(IntType intType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return 4;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(BigIntType bigIntType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return 8;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(FloatType floatType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return 4;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(DoubleType doubleType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return 8;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(DateType dateType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return 4;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(TimeType timeType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return 4;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(TimestampType timestampType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return 8;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(LocalZonedTimestampType localZonedTimestampType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return 8;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(VariantType variantType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            return Math.toIntExact(row.getVariant((int)index).sizeInBytes());
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(ArrayType arrayType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            BiFunction function = (BiFunction)arrayType.getElementType().accept((DataTypeVisitor)this);
            InternalArray internalArray = row.getArray((int)index);
            int size = 0;
            for (int i = 0; i < internalArray.size(); ++i) {
                size += ((Integer)function.apply(internalArray, i)).intValue();
            }
            return size;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(MultisetType multisetType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            BiFunction function = (BiFunction)multisetType.getElementType().accept((DataTypeVisitor)this);
            InternalMap map = row.getMap((int)index);
            int size = 0;
            for (int i = 0; i < map.size(); ++i) {
                size += ((Integer)function.apply(map.keyArray(), i)).intValue();
            }
            return size;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(MapType mapType) {
        return (row, index) -> {
            int i;
            if (row.isNullAt((int)index)) {
                return 0;
            }
            BiFunction keyFunction = (BiFunction)mapType.getKeyType().accept((DataTypeVisitor)this);
            BiFunction valueFunction = (BiFunction)mapType.getValueType().accept((DataTypeVisitor)this);
            InternalMap map = row.getMap((int)index);
            int size = 0;
            for (i = 0; i < map.size(); ++i) {
                size += ((Integer)keyFunction.apply(map.keyArray(), i)).intValue();
            }
            for (i = 0; i < map.size(); ++i) {
                size += ((Integer)valueFunction.apply(map.valueArray(), i)).intValue();
            }
            return size;
        };
    }

    public BiFunction<DataGetters, Integer, Integer> visit(RowType rowType) {
        return (row, index) -> {
            if (row.isNullAt((int)index)) {
                return 0;
            }
            int size = 0;
            List fieldTypes = rowType.getFieldTypes();
            InternalRow nestRow = row.getRow((int)index, rowType.getFieldCount());
            for (int i = 0; i < fieldTypes.size(); ++i) {
                DataType dataType = (DataType)fieldTypes.get(i);
                size += ((Integer)((BiFunction)dataType.accept((DataTypeVisitor)this)).apply(nestRow, i)).intValue();
            }
            return size;
        };
    }
}

