/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.jdbc;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.gravitino.iceberg.common.cache.SupportsMetadataLocation;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.jdbc.JdbcCatalog;
import org.apache.iceberg.jdbc.JdbcClientPool;
import org.apache.iceberg.jdbc.JdbcUtil;

public class JdbcCatalogWithMetadataLocationSupport
extends JdbcCatalog
implements SupportsMetadataLocation {
    private String jdbcCatalogName;
    private JdbcClientPool jdbcConnections;
    private JdbcUtil.SchemaVersion jdbcSchemaVersion;

    public JdbcCatalogWithMetadataLocationSupport(boolean initializeCatalogTables) {
        super(null, null, initializeCatalogTables);
    }

    public void initialize(String name, Map<String, String> properties) {
        super.initialize(name, properties);
        this.loadFields();
    }

    @Override
    public String metadataLocation(TableIdentifier tableIdentifier) {
        Map table;
        try {
            table = JdbcUtil.loadTable((JdbcUtil.SchemaVersion)this.jdbcSchemaVersion, (JdbcClientPool)this.jdbcConnections, (String)this.jdbcCatalogName, (TableIdentifier)tableIdentifier);
        }
        catch (Exception e) {
            return null;
        }
        return (String)table.get("metadata_location");
    }

    public boolean supportsViewsWithSchemaVersion() {
        return this.jdbcSchemaVersion != null && this.jdbcSchemaVersion != JdbcUtil.SchemaVersion.V0;
    }

    private void loadFields() {
        try {
            this.jdbcCatalogName = (String)FieldUtils.readField((Object)this, (String)"catalogName", (boolean)true);
            Preconditions.checkState((this.jdbcCatalogName != null ? 1 : 0) != 0, (Object)"Failed to get catalogName field from JDBC catalog");
            this.jdbcConnections = (JdbcClientPool)FieldUtils.readField((Object)this, (String)"connections", (boolean)true);
            Preconditions.checkState((this.jdbcConnections != null ? 1 : 0) != 0, (Object)"Failed to get connections field from JDBC catalog");
            this.jdbcSchemaVersion = (JdbcUtil.SchemaVersion)FieldUtils.readField((Object)this, (String)"schemaVersion", (boolean)true);
            Preconditions.checkState((this.jdbcSchemaVersion != null ? 1 : 0) != 0, (Object)"Failed to get schemaVersion field from JDBC catalog");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

