/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.gravitino.client.AuthDataProvider;

final class SimpleTokenProvider
implements AuthDataProvider {
    private final byte[] token;

    public SimpleTokenProvider() {
        String gravitinoUser = System.getenv("GRAVITINO_USER");
        if (gravitinoUser == null) {
            gravitinoUser = System.getProperty("user.name");
        }
        this.token = this.buildToken(gravitinoUser);
    }

    public SimpleTokenProvider(String gravitinoUser) {
        this.token = this.buildToken(gravitinoUser);
    }

    private byte[] buildToken(String gravitinoUser) {
        String userInformation = gravitinoUser + ":dummy";
        byte[] token = ("Basic " + new String(Base64.getEncoder().encode(userInformation.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8)).getBytes(StandardCharsets.UTF_8);
        return token;
    }

    @Override
    public boolean hasTokenData() {
        return true;
    }

    @Override
    public byte[] getTokenData() {
        return this.token;
    }

    @Override
    public void close() throws IOException {
    }
}

