/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.DoubleBooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleBooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.iterator.MutableBooleanIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.map.primitive.DoubleBooleanMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleBooleanMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleBooleanMap;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.tuple.primitive.DoubleBooleanPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedDoubleBooleanProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.BooleanBags;
import org.eclipse.collections.impl.iterator.UnmodifiableBooleanIterator;
import org.eclipse.collections.impl.map.mutable.primitive.DoubleBooleanHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;

final class ImmutableDoubleBooleanHashMap
implements ImmutableDoubleBooleanMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleBooleanMap delegate;

    ImmutableDoubleBooleanHashMap(DoubleBooleanMap delegate) {
        this.delegate = new DoubleBooleanHashMap(delegate);
    }

    public boolean get(double key) {
        return this.delegate.get(key);
    }

    public boolean getIfAbsent(double key, boolean ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean getOrThrow(double key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(double key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(boolean value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(BooleanProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(DoubleProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(DoubleBooleanProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyDoubleIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<DoubleBooleanPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableDoubleBooleanMap select(DoubleBooleanPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleBooleanMap reject(DoubleBooleanPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public RichIterable<BooleanIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableBooleanIterator iterator = this.delegate.booleanIterator();
            while (iterator.hasNext()) {
                MutableBooleanBag batch = BooleanBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    public ImmutableDoubleBooleanMap toImmutable() {
        return this;
    }

    public BooleanIterator booleanIterator() {
        return new UnmodifiableBooleanIterator((BooleanIterator)this.delegate.booleanIterator());
    }

    public void each(BooleanProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(BooleanPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableBooleanBag select(BooleanPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableBooleanBag reject(BooleanPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(BooleanToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public boolean[] toArray() {
        return this.delegate.toArray();
    }

    public boolean[] toArray(boolean[] target) {
        return this.delegate.toArray(target);
    }

    public boolean contains(boolean value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(boolean ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(BooleanIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableBooleanList toList() {
        return this.delegate.toList();
    }

    public MutableBooleanSet toSet() {
        return this.delegate.toSet();
    }

    public MutableBooleanBag toBag() {
        return this.delegate.toBag();
    }

    public LazyBooleanIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableDoubleBooleanMap newWithKeyValue(double key, boolean value) {
        DoubleBooleanHashMap map = new DoubleBooleanHashMap(this.size() + 1);
        map.putAll((DoubleBooleanMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableDoubleBooleanMap newWithoutKey(double key) {
        DoubleBooleanHashMap map = new DoubleBooleanHashMap(this.size());
        map.putAll((DoubleBooleanMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableDoubleBooleanMap newWithoutAllKeys(DoubleIterable keys) {
        DoubleBooleanHashMap map = new DoubleBooleanHashMap(this.size());
        map.putAll((DoubleBooleanMap)this);
        DoubleIterator iterator = keys.doubleIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableDoubleSet keySet() {
        return UnmodifiableDoubleSet.of(this.delegate.keySet());
    }

    public MutableBooleanCollection values() {
        return UnmodifiableBooleanCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableDoubleBooleanMapSerializationProxy((DoubleBooleanMap)this);
    }

    protected static class ImmutableDoubleBooleanMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private DoubleBooleanMap map;

        public ImmutableDoubleBooleanMapSerializationProxy() {
        }

        protected ImmutableDoubleBooleanMapSerializationProxy(DoubleBooleanMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((DoubleBooleanProcedure)new CheckedDoubleBooleanProcedure(){

                    @Override
                    public void safeValue(double key, boolean value) throws IOException {
                        out.writeDouble(key);
                        out.writeBoolean(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            DoubleBooleanHashMap deserializedMap = new DoubleBooleanHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readDouble(), in.readBoolean());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

