/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authentication;

import com.google.common.base.Splitter;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Base64;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyTab;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.UserPrincipal;
import org.apache.gravitino.auth.KerberosUtils;
import org.apache.gravitino.exceptions.UnauthorizedException;
import org.apache.gravitino.server.authentication.Authenticator;
import org.apache.gravitino.server.authentication.KerberosConfig;
import org.apache.gravitino.server.authentication.KerberosServerUtils;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthenticator
implements Authenticator {
    public static final Logger LOG = LoggerFactory.getLogger(KerberosAuthenticator.class);
    private final Subject serverSubject = new Subject();
    private GSSManager gssManager;

    @Override
    public void initialize(Config config) throws RuntimeException {
        try {
            String principal = (String)config.get(KerberosConfig.PRINCIPAL);
            if (!principal.startsWith("HTTP/")) {
                throw new IllegalArgumentException("Principal must starts with `HTTP/`");
            }
            String keytab = (String)config.get(KerberosConfig.KEYTAB);
            File keytabFile = new File(keytab);
            if (!keytabFile.exists()) {
                throw new IllegalArgumentException(String.format("Keytab %s doesn't exist", keytab));
            }
            if (!keytabFile.canRead()) {
                throw new IllegalArgumentException(String.format("Keytab %s can't be read", keytab));
            }
            KerberosPrincipal krbPrincipal = new KerberosPrincipal(principal);
            LOG.info("Using keytab {}, for principal {}", (Object)keytab, (Object)krbPrincipal);
            this.serverSubject.getPrincipals().add(krbPrincipal);
            KeyTab keytabInstance = KeyTab.getInstance(keytabFile);
            this.serverSubject.getPrivateCredentials().add(keytabInstance);
            this.gssManager = Subject.doAs(this.serverSubject, new PrivilegedExceptionAction<GSSManager>(){

                @Override
                public GSSManager run() throws Exception {
                    return GSSManager.getInstance();
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean isDataFromToken() {
        return true;
    }

    @Override
    public Principal authenticateToken(byte[] tokenData) {
        if (tokenData == null) {
            throw new UnauthorizedException("Empty token authorization header", "Negotiate");
        }
        String authData = new String(tokenData, StandardCharsets.UTF_8);
        if (StringUtils.isBlank((CharSequence)authData) || !authData.startsWith("Negotiate ")) {
            throw new UnauthorizedException("Invalid token authorization header", "Negotiate");
        }
        String token = authData.substring("Negotiate ".length());
        final byte[] clientToken = Base64.getDecoder().decode(token);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new UnauthorizedException("Blank token found", "Negotiate");
        }
        try {
            final String serverPrincipal = KerberosServerUtils.getTokenServerName(clientToken);
            if (!serverPrincipal.startsWith("HTTP/")) {
                throw new IllegalArgumentException("Principal must start with `HTTP/`");
            }
            return Subject.doAs(this.serverSubject, new PrivilegedExceptionAction<Principal>(){

                @Override
                public Principal run() throws Exception {
                    return KerberosAuthenticator.this.retrievePrincipalFromToken(serverPrincipal, clientToken);
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Fail to validate the token, exception: ", (Throwable)e);
            throw new UnauthorizedException("Fail to validate the token", "Negotiate");
        }
    }

    @Override
    public boolean supportsToken(byte[] tokenData) {
        return tokenData != null && new String(tokenData, StandardCharsets.UTF_8).startsWith("Negotiate ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Principal retrievePrincipalFromToken(String serverPrincipal, byte[] clientToken) throws GSSException {
        GSSContext gssContext = null;
        GSSCredential gssCreds = null;
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("SPNEGO initiated with server principal [{}]", (Object)serverPrincipal);
            }
            gssCreds = this.gssManager.createCredential(this.gssManager.createName(serverPrincipal, KerberosUtils.NT_GSS_KRB5_PRINCIPAL_OID), Integer.MAX_VALUE, new Oid[]{KerberosUtils.GSS_SPNEGO_MECH_OID, KerberosUtils.GSS_KRB5_MECH_OID}, 2);
            gssContext = this.gssManager.createContext(gssCreds);
            byte[] serverToken = gssContext.acceptSecContext(clientToken, 0, clientToken.length);
            String authenticateToken = null;
            if (serverToken != null && serverToken.length > 0) {
                authenticateToken = Base64.getEncoder().encodeToString(serverToken);
            }
            if (!gssContext.isEstablished()) {
                LOG.trace("SPNEGO in progress");
                String challenge = "Negotiate " + authenticateToken;
                throw new UnauthorizedException("GssContext isn't established", challenge);
            }
            List principalComponents = Splitter.on((char)'@').splitToList((CharSequence)gssContext.getSrcName().toString());
            if (principalComponents.size() != 2) {
                throw new UnauthorizedException("Principal has wrong format", "Negotiate");
            }
            String user = (String)principalComponents.get(0);
            UserPrincipal userPrincipal = new UserPrincipal(user);
            return userPrincipal;
        }
        finally {
            if (gssContext != null) {
                gssContext.dispose();
            }
            if (gssCreds != null) {
                gssCreds.dispose();
            }
        }
    }
}

