/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.collections.Lists;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.TestNGMethod;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.reflect.ReflectionHelper;
import org.testng.junit.INameFilter;
import org.testng.xml.XmlTest;

public class JUnitMethodFinder
implements ITestMethodFinder {
    private final ITestObjectFactory objectFactory;
    private final IAnnotationFinder m_annotationFinder;

    public JUnitMethodFinder(ITestObjectFactory objectFactory, IAnnotationFinder finder) {
        this.objectFactory = objectFactory;
        this.m_annotationFinder = finder;
    }

    @Override
    public ITestNGMethod[] getTestMethods(Class<?> cls, XmlTest xmlTest) {
        return this.privateFindTestMethods(method -> method.getName().startsWith("test") && method.getParameterTypes().length == 0, cls);
    }

    private ITestNGMethod[] privateFindTestMethods(INameFilter filter, Class<?> cls) {
        List vResult = Lists.newArrayList();
        HashSet<String> acceptedMethodNames = new HashSet<String>();
        for (Class<?> current = cls; current != Object.class; current = current.getSuperclass()) {
            Method[] allMethods;
            for (Method allMethod : allMethods = ReflectionHelper.excludingMain(current)) {
                TestNGMethod m = new TestNGMethod(this.objectFactory, allMethod, this.m_annotationFinder, null, null);
                ConstructorOrMethod method = m.getConstructorOrMethod();
                String methodName = method.getName();
                if (!filter.accept(method) || acceptedMethodNames.contains(methodName)) continue;
                vResult.add(m);
                acceptedMethodNames.add(methodName);
            }
        }
        return vResult.toArray(new ITestNGMethod[0]);
    }

    @Override
    public ITestNGMethod[] getBeforeTestMethods(Class<?> cls) {
        return this.privateFindTestMethods(method -> "setUp".equals(method.getName()), cls);
    }

    @Override
    public ITestNGMethod[] getAfterTestMethods(Class<?> cls) {
        return this.privateFindTestMethods(method -> "tearDown".equals(method.getName()), cls);
    }

    @Override
    public ITestNGMethod[] getAfterClassMethods(Class<?> cls) {
        return new ITestNGMethod[0];
    }

    @Override
    public ITestNGMethod[] getBeforeClassMethods(Class<?> cls) {
        return new ITestNGMethod[0];
    }

    @Override
    public ITestNGMethod[] getBeforeSuiteMethods(Class<?> cls) {
        return new ITestNGMethod[0];
    }

    @Override
    public ITestNGMethod[] getAfterSuiteMethods(Class<?> cls) {
        return new ITestNGMethod[0];
    }

    @Override
    public ITestNGMethod[] getBeforeTestConfigurationMethods(Class<?> testClass) {
        return new ITestNGMethod[0];
    }

    @Override
    public ITestNGMethod[] getAfterTestConfigurationMethods(Class<?> testClass) {
        return new ITestNGMethod[0];
    }

    @Override
    public ITestNGMethod[] getBeforeGroupsConfigurationMethods(Class<?> testClass) {
        return new ITestNGMethod[0];
    }

    @Override
    public ITestNGMethod[] getAfterGroupsConfigurationMethods(Class<?> testClass) {
        return new ITestNGMethod[0];
    }
}

