/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ReplicationLoadSink {
    private final long ageOfLastAppliedOp;
    private final long timestampsOfLastAppliedOp;
    private final long timestampStarted;
    private final long totalOpsProcessed;

    public ReplicationLoadSink(long age, long timestamp, long timestampStarted, long totalOpsProcessed) {
        this.ageOfLastAppliedOp = age;
        this.timestampsOfLastAppliedOp = timestamp;
        this.timestampStarted = timestampStarted;
        this.totalOpsProcessed = totalOpsProcessed;
    }

    public long getAgeOfLastAppliedOp() {
        return this.ageOfLastAppliedOp;
    }

    @Deprecated
    public long getTimeStampsOfLastAppliedOp() {
        return this.getTimestampsOfLastAppliedOp();
    }

    public long getTimestampsOfLastAppliedOp() {
        return this.timestampsOfLastAppliedOp;
    }

    public long getTimestampStarted() {
        return this.timestampStarted;
    }

    public long getTotalOpsProcessed() {
        return this.totalOpsProcessed;
    }

    @InterfaceAudience.Private
    public static ReplicationLoadSinkBuilder newBuilder() {
        return new ReplicationLoadSinkBuilder();
    }

    @InterfaceAudience.Private
    public static final class ReplicationLoadSinkBuilder {
        private long ageOfLastAppliedOp;
        private long timestampsOfLastAppliedOp;
        private long timestampStarted;
        private long totalOpsProcessed;

        private ReplicationLoadSinkBuilder() {
        }

        public ReplicationLoadSinkBuilder setAgeOfLastAppliedOp(long ageOfLastAppliedOp) {
            this.ageOfLastAppliedOp = ageOfLastAppliedOp;
            return this;
        }

        public ReplicationLoadSinkBuilder setTimestampsOfLastAppliedOp(long timestampsOfLastAppliedOp) {
            this.timestampsOfLastAppliedOp = timestampsOfLastAppliedOp;
            return this;
        }

        public ReplicationLoadSinkBuilder setTimestampStarted(long timestampStarted) {
            this.timestampStarted = timestampStarted;
            return this;
        }

        public ReplicationLoadSinkBuilder setTotalOpsProcessed(long totalOpsProcessed) {
            this.totalOpsProcessed = totalOpsProcessed;
            return this;
        }

        public ReplicationLoadSink build() {
            return new ReplicationLoadSink(this.ageOfLastAppliedOp, this.timestampsOfLastAppliedOp, this.timestampStarted, this.totalOpsProcessed);
        }
    }
}

