/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.Options;

public final class InternalConstants {
    public static final boolean DELETE_CONSIDERED_IDEMPOTENT = true;
    public static final int DRAIN_BUFFER_SIZE = 16384;
    public static final int RENAME_PARALLEL_LIMIT = 10;
    public static final int MAX_ENTRIES_TO_DELETE = 1000;
    public static final int DEFAULT_BLOCKSIZE = 0x2000000;
    @InterfaceStability.Unstable
    public static final Set<String> S3A_OPENFILE_KEYS;
    public static final int SC_200_OK = 200;
    public static final int SC_301_MOVED_PERMANENTLY = 301;
    public static final int SC_307_TEMPORARY_REDIRECT = 307;
    public static final int SC_400_BAD_REQUEST = 400;
    public static final int SC_401_UNAUTHORIZED = 401;
    public static final int SC_403_FORBIDDEN = 403;
    @Deprecated
    public static final int SC_403 = 403;
    public static final int SC_404_NOT_FOUND = 404;
    @Deprecated
    public static final int SC_404 = 404;
    public static final int SC_405_METHOD_NOT_ALLOWED = 405;
    public static final int SC_409_CONFLICT = 409;
    public static final int SC_410_GONE = 410;
    public static final int SC_412_PRECONDITION_FAILED = 412;
    public static final int SC_415_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int SC_416_RANGE_NOT_SATISFIABLE = 416;
    public static final int SC_429_TOO_MANY_REQUESTS_GCS = 429;
    public static final int SC_443_NO_RESPONSE = 443;
    public static final int SC_444_NO_RESPONSE = 444;
    public static final int SC_500_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_501_NOT_IMPLEMENTED = 501;
    public static final int SC_503_SERVICE_UNAVAILABLE = 503;
    public static final int SC_504_GATEWAY_TIMEOUT = 504;
    public static final String THROTTLE_LOG_NAME = "org.apache.hadoop.fs.s3a.throttled";
    public static final String SDK_V2_UPGRADE_LOG_NAME = "org.apache.hadoop.fs.s3a.SDKV2Upgrade";
    public static final String X_DIRECTORY = "application/x-directory";
    @VisibleForTesting
    public static final String UPLOAD_PART_COUNT_LIMIT = "fs.s3a.internal.upload.part.count.limit";
    public static final int DEFAULT_UPLOAD_PART_COUNT_LIMIT = 10000;
    public static final String AWS_REGION_SYSPROP = "aws.region";
    public static final int CSE_PADDING_LENGTH = 16;
    public static final String AP_REQUIRED_EXCEPTION = "Access Points usage is required but not configured for the bucket.";
    public static final String AP_INACCESSIBLE = "Could not access through this access point";
    public static final String ARN_BUCKET_OPTION = "fs.s3a.bucket.%s.accesspoint.arn";
    public static final Set<String> CREATE_FILE_KEYS;
    public static final List<String> S3A_DYNAMIC_CAPABILITIES;
    public static final String AUTH_SCHEME_AWS_SIGV_4 = "aws.auth#sigv4";
    public static final String UPLOAD_PROGRESS_LOG_NAME = "org.apache.hadoop.fs.s3a.S3AFileSystem.Progress";
    public static final String PRECONDITION_FAILED = "PreconditionFailed";

    private InternalConstants() {
    }

    static {
        Set keys = Stream.of("fs.s3a.input.async.drain.threshold", "fs.s3a.experimental.input.fadvise", "fs.s3a.readahead.range").collect(Collectors.toSet());
        keys.addAll(Options.OpenFileOptions.FS_OPTION_OPENFILE_STANDARD_OPTIONS);
        S3A_OPENFILE_KEYS = Collections.unmodifiableSet(keys);
        CREATE_FILE_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("fs.option.create.conditional.overwrite", "fs.option.create.conditional.overwrite.etag", "fs.option.create.in.close", "fs.option.create.content.type", "fs.s3a.create.performance", "fs.s3a.create.multipart")));
        S3A_DYNAMIC_CAPABILITIES = Collections.unmodifiableList(Arrays.asList("fs.capability.etags.available", "fs.capability.paths.checksums", "fs.capability.multipart.uploader", "fs.capability.directory.listing.inconsistent", "fs.s3a.endpoint.fips", "fs.s3a.capability.aws.v2", "fs.s3a.capability.directory.marker.policy.keep", "fs.s3a.capability.directory.marker.policy.delete", "fs.s3a.capability.directory.marker.policy.authoritative", "fs.s3a.capability.directory.marker.action.keep", "fs.s3a.capability.directory.marker.action.delete", "fs.s3a.capability.magic.committer", "fs.s3a.capability.multipart.uploads.enabled", "fs.s3a.capability.s3express.storage", "fs.s3a.create.performance.enabled", "fs.s3a.directory.operations.purge.uploads", "fs.s3a.multiobjectdelete.enable"));
    }
}

