/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.DataInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.typedbytes.TypedBytesInput;
import org.apache.hadoop.typedbytes.TypedBytesWritable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class LoadTypedBytes
implements Tool {
    private Configuration conf;

    public LoadTypedBytes(Configuration conf) {
        this.conf = conf;
    }

    public LoadTypedBytes() {
        this(new Configuration());
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Too few arguments!");
            this.printUsage();
            return 1;
        }
        Path path = new Path(args[0]);
        FileSystem fs = path.getFileSystem(this.getConf());
        if (fs.exists(path)) {
            System.err.println("given path exists already!");
            return -1;
        }
        TypedBytesInput tbinput = new TypedBytesInput(new DataInputStream(System.in));
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)path, TypedBytesWritable.class, TypedBytesWritable.class);){
            TypedBytesWritable key = new TypedBytesWritable();
            TypedBytesWritable value = new TypedBytesWritable();
            byte[] rawKey = tbinput.readRaw();
            while (rawKey != null) {
                byte[] rawValue = tbinput.readRaw();
                key.set(rawKey, 0, rawKey.length);
                value.set(rawValue, 0, rawValue.length);
                writer.append((Writable)key, (Writable)value);
                rawKey = tbinput.readRaw();
            }
        }
        return 0;
    }

    private void printUsage() {
        System.out.println("Usage: mapred streaming loadtb <path>");
        System.out.println("  Reads typed bytes from standard input and stores them in a sequence file in");
        System.out.println("  the specified path");
    }

    public static void main(String[] args) throws Exception {
        LoadTypedBytes loadtb = new LoadTypedBytes();
        int res = ToolRunner.run((Tool)loadtb, (String[])args);
        System.exit(res);
    }
}

