/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp.cache;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebAppUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterAppInfoCacheKey {
    private static String user = "YarnRouter";
    private static final Logger LOG = LoggerFactory.getLogger((String)RouterAppInfoCacheKey.class.getName());
    private UserGroupInformation ugi;
    private String stateQuery;
    private Set<String> statesQuery;
    private String finalStatusQuery;
    private String userQuery;
    private String queueQuery;
    private String count;
    private String startedBegin;
    private String startedEnd;
    private String finishBegin;
    private String finishEnd;
    private Set<String> applicationTypes;
    private Set<String> applicationTags;
    private String name;
    private Set<String> unselectedFields;

    public RouterAppInfoCacheKey() {
    }

    public RouterAppInfoCacheKey(UserGroupInformation ugi, String stateQuery, Set<String> statesQuery, String finalStatusQuery, String userQuery, String queueQuery, String count, String startedBegin, String startedEnd, String finishBegin, String finishEnd, Set<String> applicationTypes, Set<String> applicationTags, String name, Set<String> unselectedFields) {
        this.ugi = ugi;
        this.stateQuery = stateQuery;
        this.statesQuery = statesQuery;
        this.finalStatusQuery = finalStatusQuery;
        this.userQuery = userQuery;
        this.queueQuery = queueQuery;
        this.count = count;
        this.startedBegin = startedBegin;
        this.startedEnd = startedEnd;
        this.finishBegin = finishBegin;
        this.finishEnd = finishEnd;
        this.applicationTypes = applicationTypes;
        this.applicationTags = applicationTags;
        this.name = name;
        this.unselectedFields = unselectedFields;
    }

    public static RouterAppInfoCacheKey newInstance(HttpServletRequest hsr, String stateQuery, Set<String> statesQuery, String finalStatusQuery, String userQuery, String queueQuery, String count, String startedBegin, String startedEnd, String finishBegin, String finishEnd, Set<String> applicationTypes, Set<String> applicationTags, String name, Set<String> unselectedFields) {
        UserGroupInformation callerUGI = null;
        callerUGI = hsr != null ? RMWebAppUtil.getCallerUserGroupInformation((HttpServletRequest)hsr, (boolean)true) : UserGroupInformation.createRemoteUser((String)"YarnRouter");
        if (callerUGI == null) {
            LOG.error("Unable to obtain user name, user not authenticated.");
            return null;
        }
        return new RouterAppInfoCacheKey(callerUGI, stateQuery, statesQuery, finalStatusQuery, userQuery, queueQuery, count, startedBegin, startedEnd, finishBegin, finishEnd, applicationTypes, applicationTags, name, unselectedFields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouterAppInfoCacheKey that = (RouterAppInfoCacheKey)o;
        return new EqualsBuilder().append((Object)this.ugi.getUserName(), (Object)that.ugi.getUserName()).append((Object)this.stateQuery, (Object)that.stateQuery).append(this.statesQuery, that.statesQuery).append((Object)this.finalStatusQuery, (Object)that.finalStatusQuery).append((Object)this.userQuery, (Object)that.userQuery).append((Object)this.queueQuery, (Object)that.queueQuery).append((Object)this.count, (Object)that.count).append((Object)this.startedBegin, (Object)that.startedBegin).append((Object)this.startedEnd, (Object)that.startedEnd).append((Object)this.finishBegin, (Object)that.finishBegin).append((Object)this.finishEnd, (Object)that.finishEnd).append(this.applicationTypes, that.applicationTypes).append(this.applicationTags, that.applicationTags).append((Object)this.name, (Object)that.name).append(this.unselectedFields, that.unselectedFields).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.ugi.getUserName()).append((Object)this.stateQuery).append(this.statesQuery).append((Object)this.finalStatusQuery).append((Object)this.userQuery).append((Object)this.queueQuery).append((Object)this.count).append((Object)this.startedBegin).append((Object)this.startedEnd).append((Object)this.finishBegin).append((Object)this.finishEnd).append(this.applicationTypes).append(this.applicationTags).append((Object)this.name).append(this.unselectedFields).toHashCode();
    }
}

