/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.retry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FederationActionRetry<T> {
    public static final Logger LOG = LoggerFactory.getLogger(FederationActionRetry.class);

    public T run(int var1) throws Exception;

    default public T runWithRetries(int retryCount, long retrySleepTime) throws Exception {
        int retry = 0;
        while (true) {
            try {
                return this.run(retry);
            }
            catch (Exception e) {
                LOG.info("Exception while executing an Federation operation.", (Throwable)e);
                if (++retry > retryCount) {
                    LOG.info("Maxed out Federation retries. Giving up!");
                    throw e;
                }
                LOG.info("Retrying operation on Federation. Retry no. {}", (Object)retry);
                Thread.sleep(retrySleepTime);
                continue;
            }
            break;
        }
    }
}

