/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestCryptoOutputStreamClosing {
    private static CryptoCodec codec;

    @BeforeClass
    public static void init() throws Exception {
        codec = CryptoCodec.getInstance((Configuration)new Configuration());
    }

    @Test
    public void testOutputStreamClosing() throws Exception {
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        CryptoOutputStream cos = new CryptoOutputStream(outputStream, codec, new byte[16], new byte[16], 0L, true);
        cos.close();
        ((OutputStream)Mockito.verify((Object)outputStream)).close();
    }

    @Test
    public void testOutputStreamNotClosing() throws Exception {
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        CryptoOutputStream cos = new CryptoOutputStream(outputStream, codec, new byte[16], new byte[16], 0L, false);
        cos.close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testUnderlyingOutputStreamClosedWhenExceptionClosing() throws Exception {
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        CryptoOutputStream cos = (CryptoOutputStream)Mockito.spy((Object)new CryptoOutputStream(outputStream, codec, new byte[16], new byte[16], 0L, true));
        ((CryptoOutputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("problem flushing wrapped stream")}).when((Object)cos)).flush();
        LambdaTestUtils.intercept(IOException.class, () -> cos.close());
        ((OutputStream)Mockito.verify((Object)outputStream)).close();
    }
}

