/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRoundRobinVolumeChoosingPolicy {
    @Test
    public void testRR() throws Exception {
        RoundRobinVolumeChoosingPolicy policy = (RoundRobinVolumeChoosingPolicy)ReflectionUtils.newInstance(RoundRobinVolumeChoosingPolicy.class, null);
        TestRoundRobinVolumeChoosingPolicy.testRR((VolumeChoosingPolicy<FsVolumeSpi>)policy);
    }

    public static void testRR(VolumeChoosingPolicy<FsVolumeSpi> policy) throws Exception {
        ArrayList<Object> volumes = new ArrayList<Object>();
        volumes.add(Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(0)).getAvailable()).thenReturn((Object)100L);
        volumes.add(Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(1)).getAvailable()).thenReturn((Object)200L);
        Assert.assertEquals(volumes.get(0), (Object)policy.chooseVolume(volumes, 0L, null));
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 0L, null));
        Assert.assertEquals(volumes.get(0), (Object)policy.chooseVolume(volumes, 0L, null));
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 0L, null));
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 150L, null));
        try {
            policy.chooseVolume(volumes, Long.MAX_VALUE, null);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRRWithAdditionalAvailableSpace() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.datanode.round-robin-volume-choosing-policy.additional-available-space", 100L);
        RoundRobinVolumeChoosingPolicy policy = (RoundRobinVolumeChoosingPolicy)ReflectionUtils.newInstance(RoundRobinVolumeChoosingPolicy.class, (Configuration)conf);
        TestRoundRobinVolumeChoosingPolicy.testRRWithAdditionalAvailableSpace((VolumeChoosingPolicy<FsVolumeSpi>)policy);
    }

    public static void testRRWithAdditionalAvailableSpace(VolumeChoosingPolicy<FsVolumeSpi> policy) throws Exception {
        ArrayList<Object> volumes = new ArrayList<Object>();
        volumes.add(Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(0)).getAvailable()).thenReturn((Object)100L);
        volumes.add(Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(1)).getAvailable()).thenReturn((Object)200L);
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 0L, null));
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 0L, null));
        try {
            policy.chooseVolume(volumes, 100L, null);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRRPolicyExceptionMessage() throws Exception {
        RoundRobinVolumeChoosingPolicy policy = new RoundRobinVolumeChoosingPolicy();
        TestRoundRobinVolumeChoosingPolicy.testRRPolicyExceptionMessage((VolumeChoosingPolicy<FsVolumeSpi>)policy);
    }

    public static void testRRPolicyExceptionMessage(VolumeChoosingPolicy<FsVolumeSpi> policy) throws Exception {
        ArrayList<Object> volumes = new ArrayList<Object>();
        volumes.add(Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(0)).getAvailable()).thenReturn((Object)500L);
        volumes.add(Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)volumes.get(1)).getAvailable()).thenReturn((Object)600L);
        int blockSize = 700;
        try {
            policy.chooseVolume(volumes, (long)blockSize, null);
            Assert.fail((String)"expected to throw DiskOutOfSpaceException");
        }
        catch (DiskChecker.DiskOutOfSpaceException e) {
            Assert.assertEquals((String)"Not returnig the expected message", (Object)("Out of space: The volume with the most available space (=600 B) is less than the block size (=" + blockSize + " B)."), (Object)e.getMessage());
        }
    }

    @Test
    public void testRRPolicyWithStorageTypes() throws Exception {
        RoundRobinVolumeChoosingPolicy policy = new RoundRobinVolumeChoosingPolicy();
        TestRoundRobinVolumeChoosingPolicy.testRRPolicyWithStorageTypes((VolumeChoosingPolicy<FsVolumeSpi>)policy);
    }

    public static void testRRPolicyWithStorageTypes(VolumeChoosingPolicy<FsVolumeSpi> policy) throws Exception {
        ArrayList<Object> diskVolumes = new ArrayList<Object>();
        ArrayList<Object> ssdVolumes = new ArrayList<Object>();
        diskVolumes.add(Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)diskVolumes.get(0)).getStorageType()).thenReturn((Object)StorageType.DISK);
        Mockito.when((Object)((FsVolumeSpi)diskVolumes.get(0)).getAvailable()).thenReturn((Object)100L);
        diskVolumes.add(Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)diskVolumes.get(1)).getStorageType()).thenReturn((Object)StorageType.DISK);
        Mockito.when((Object)((FsVolumeSpi)diskVolumes.get(1)).getAvailable()).thenReturn((Object)100L);
        ssdVolumes.add(Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)ssdVolumes.get(0)).getStorageType()).thenReturn((Object)StorageType.SSD);
        Mockito.when((Object)((FsVolumeSpi)ssdVolumes.get(0)).getAvailable()).thenReturn((Object)200L);
        ssdVolumes.add(Mockito.mock(FsVolumeSpi.class));
        Mockito.when((Object)((FsVolumeSpi)ssdVolumes.get(1)).getStorageType()).thenReturn((Object)StorageType.SSD);
        Mockito.when((Object)((FsVolumeSpi)ssdVolumes.get(1)).getAvailable()).thenReturn((Object)100L);
        Assert.assertEquals(diskVolumes.get(0), (Object)policy.chooseVolume(diskVolumes, 0L, null));
        Assert.assertEquals(ssdVolumes.get(0), (Object)policy.chooseVolume(ssdVolumes, 0L, null));
        Assert.assertEquals(ssdVolumes.get(0), (Object)policy.chooseVolume(ssdVolumes, 150L, null));
        Assert.assertEquals(diskVolumes.get(1), (Object)policy.chooseVolume(diskVolumes, 0L, null));
        Assert.assertEquals(diskVolumes.get(0), (Object)policy.chooseVolume(diskVolumes, 50L, null));
        try {
            policy.chooseVolume(diskVolumes, 200L, null);
            Assert.fail((String)"Should throw an DiskOutOfSpaceException before this!");
        }
        catch (DiskChecker.DiskOutOfSpaceException diskOutOfSpaceException) {
            // empty catch block
        }
    }
}

