/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical.impl;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.logical.LogicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.logical.impl.ParquetColumnPrefetchStore;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ColumnMappers;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ParquetMetadataParsingTask;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ParquetPredictivePrefetchingTask;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ParquetPrefetchRemainingColumnTask;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ParquetPrefetchTailTask;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ParquetReadTailTask;
import software.amazon.s3.analyticsaccelerator.io.logical.parquet.ParquetUtils;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIO;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlanExecution;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlanState;
import software.amazon.s3.analyticsaccelerator.util.PrefetchMode;
import software.amazon.s3.analyticsaccelerator.util.RequestCallback;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class ParquetPrefetcher {
    @NonNull
    private final S3URI s3URI;
    @NonNull
    private final LogicalIOConfiguration logicalIOConfiguration;
    @NonNull
    private final ParquetColumnPrefetchStore parquetColumnPrefetchStore;
    @NonNull
    private final Telemetry telemetry;
    @NonNull
    private final ParquetMetadataParsingTask parquetMetadataParsingTask;
    @NonNull
    private final ParquetPrefetchTailTask parquetPrefetchTailTask;
    @NonNull
    private final ParquetReadTailTask parquetReadTailTask;
    @NonNull
    private final ParquetPrefetchRemainingColumnTask parquetPrefetchRemainingColumnTask;
    @NonNull
    private final ParquetPredictivePrefetchingTask parquetPredictivePrefetchingTask;
    private static final Logger LOG = LoggerFactory.getLogger(ParquetPrefetcher.class);
    private static final String OPERATION_PARQUET_PREFETCH_COLUMN_CHUNK = "parquet.prefetcher.prefetch.column.chunk.async";
    private static final String OPERATION_PARQUET_PREFETCH_FOOTER_AND_METADATA = "parquet.prefetcher.prefetch.footer.and.metadata.async";

    public ParquetPrefetcher(S3URI s3Uri, PhysicalIO physicalIO, Telemetry telemetry, LogicalIOConfiguration logicalIOConfiguration, ParquetColumnPrefetchStore parquetColumnPrefetchStore, RequestCallback requestCallback) {
        this(s3Uri, logicalIOConfiguration, parquetColumnPrefetchStore, telemetry, new ParquetMetadataParsingTask(s3Uri, parquetColumnPrefetchStore, requestCallback), new ParquetPrefetchTailTask(s3Uri, telemetry, logicalIOConfiguration, physicalIO), new ParquetReadTailTask(s3Uri, telemetry, logicalIOConfiguration, physicalIO), new ParquetPrefetchRemainingColumnTask(s3Uri, telemetry, physicalIO, parquetColumnPrefetchStore), new ParquetPredictivePrefetchingTask(s3Uri, telemetry, logicalIOConfiguration, physicalIO, parquetColumnPrefetchStore));
    }

    public CompletableFuture<IOPlanExecution> prefetchRemainingColumnChunk(long position, int len) {
        return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_PARQUET_PREFETCH_COLUMN_CHUNK)).attribute(StreamAttributes.uri(this.s3URI))).attribute(StreamAttributes.range(position, position + (long)len - 1L))).build(), this.prefetchRemainingColumnChunkImpl(position, len));
    }

    private CompletableFuture<IOPlanExecution> prefetchRemainingColumnChunkImpl(long position, int len) {
        if (this.logicalIOConfiguration.getPrefetchingMode() == PrefetchMode.COLUMN_BOUND) {
            return CompletableFuture.supplyAsync(() -> this.parquetPrefetchRemainingColumnTask.prefetchRemainingColumnChunk(position, len));
        }
        return CompletableFuture.completedFuture(IOPlanExecution.builder().state(IOPlanState.SKIPPED).build());
    }

    public CompletableFuture<IOPlanExecution> prefetchFooterAndBuildMetadata() {
        return this.telemetry.measureStandard(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_PARQUET_PREFETCH_FOOTER_AND_METADATA)).attribute(StreamAttributes.uri(this.s3URI))).build(), this.prefetchFooterAndBuildMetadataImpl());
    }

    private CompletableFuture<IOPlanExecution> prefetchFooterAndBuildMetadataImpl() {
        if (this.logicalIOConfiguration.isPrefetchFooterEnabled()) {
            this.parquetPrefetchTailTask.prefetchTail();
        }
        if (this.shouldPrefetch()) {
            CompletionStage columnMappersCompletableFuture = ((CompletableFuture)CompletableFuture.supplyAsync(this.parquetReadTailTask::readFileTail).thenApply(this.parquetMetadataParsingTask::storeColumnMappers)).exceptionally(e -> new ColumnMappers(Collections.emptyMap(), Collections.emptyMap()));
            return this.prefetchPredictedColumns((CompletableFuture<ColumnMappers>)columnMappersCompletableFuture);
        }
        return CompletableFuture.completedFuture(IOPlanExecution.builder().state(IOPlanState.SKIPPED).build());
    }

    private CompletableFuture<IOPlanExecution> prefetchPredictedColumns(CompletableFuture<ColumnMappers> columnMappersCompletableFuture) {
        if (this.logicalIOConfiguration.getPrefetchingMode() == PrefetchMode.ALL) {
            return columnMappersCompletableFuture.thenApply(columnMappers -> this.parquetPredictivePrefetchingTask.prefetchRecentColumns((ColumnMappers)columnMappers, ParquetUtils.constructRowGroupsToPrefetch(), false));
        }
        return CompletableFuture.completedFuture(IOPlanExecution.builder().state(IOPlanState.SKIPPED).build());
    }

    public void addToRecentColumnList(long position, int len) {
        try {
            if (this.logicalIOConfiguration.getPrefetchingMode() != PrefetchMode.OFF) {
                this.parquetPredictivePrefetchingTask.addToRecentColumnList(position, len);
            }
        }
        catch (Exception e) {
            LOG.debug("Unable to add column to recently read columns tracked list for {}.", (Object)this.s3URI.getKey(), (Object)e);
        }
    }

    private boolean shouldPrefetch() {
        return this.logicalIOConfiguration.getPrefetchingMode() != PrefetchMode.OFF && this.parquetColumnPrefetchStore.getColumnMappers(this.s3URI) == null;
    }

    @Generated
    ParquetPrefetcher(@NonNull S3URI s3URI, @NonNull LogicalIOConfiguration logicalIOConfiguration, @NonNull ParquetColumnPrefetchStore parquetColumnPrefetchStore, @NonNull Telemetry telemetry, @NonNull ParquetMetadataParsingTask parquetMetadataParsingTask, @NonNull ParquetPrefetchTailTask parquetPrefetchTailTask, @NonNull ParquetReadTailTask parquetReadTailTask, @NonNull ParquetPrefetchRemainingColumnTask parquetPrefetchRemainingColumnTask, @NonNull ParquetPredictivePrefetchingTask parquetPredictivePrefetchingTask) {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (logicalIOConfiguration == null) {
            throw new NullPointerException("logicalIOConfiguration is marked non-null but is null");
        }
        if (parquetColumnPrefetchStore == null) {
            throw new NullPointerException("parquetColumnPrefetchStore is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (parquetMetadataParsingTask == null) {
            throw new NullPointerException("parquetMetadataParsingTask is marked non-null but is null");
        }
        if (parquetPrefetchTailTask == null) {
            throw new NullPointerException("parquetPrefetchTailTask is marked non-null but is null");
        }
        if (parquetReadTailTask == null) {
            throw new NullPointerException("parquetReadTailTask is marked non-null but is null");
        }
        if (parquetPrefetchRemainingColumnTask == null) {
            throw new NullPointerException("parquetPrefetchRemainingColumnTask is marked non-null but is null");
        }
        if (parquetPredictivePrefetchingTask == null) {
            throw new NullPointerException("parquetPredictivePrefetchingTask is marked non-null but is null");
        }
        this.s3URI = s3URI;
        this.logicalIOConfiguration = logicalIOConfiguration;
        this.parquetColumnPrefetchStore = parquetColumnPrefetchStore;
        this.telemetry = telemetry;
        this.parquetMetadataParsingTask = parquetMetadataParsingTask;
        this.parquetPrefetchTailTask = parquetPrefetchTailTask;
        this.parquetReadTailTask = parquetReadTailTask;
        this.parquetPrefetchRemainingColumnTask = parquetPrefetchRemainingColumnTask;
        this.parquetPredictivePrefetchingTask = parquetPredictivePrefetchingTask;
    }
}

