/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlock;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;

public class AbfsBlobBlock
extends AbfsBlock {
    private final String blockId;
    private final long blockIndex;

    AbfsBlobBlock(AbfsOutputStream outputStream, long offset, int blockIdLength, long blockIndex) throws IOException {
        super(outputStream, offset);
        this.blockIndex = blockIndex;
        String streamId = outputStream.getStreamID();
        UUID streamIdGuid = UUID.nameUUIDFromBytes(streamId.getBytes(StandardCharsets.UTF_8));
        this.blockId = this.generateBlockId(streamIdGuid, blockIdLength);
    }

    private String generateBlockId(UUID streamId, int rawLength) {
        String rawBlockId = String.format("%s-%06d", streamId, this.blockIndex);
        if (rawLength != 0) {
            if (rawBlockId.length() < rawLength) {
                rawBlockId = String.format("%-" + rawLength + "s", rawBlockId).replace(' ', '_');
            } else if (rawBlockId.length() > rawLength) {
                rawBlockId = rawBlockId.substring(0, rawLength);
            }
        }
        return Base64.encodeBase64String((byte[])rawBlockId.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getBlockId() {
        return this.blockId;
    }
}

