/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.csi.utils;

import io.netty.channel.unix.DomainSocketAddress;
import java.io.File;
import java.net.SocketAddress;

public final class GrpcHelper {
    protected static final String UNIX_DOMAIN_SOCKET_PREFIX = "unix://";

    private GrpcHelper() {
    }

    public static SocketAddress getSocketAddress(String value) {
        if (value.startsWith(UNIX_DOMAIN_SOCKET_PREFIX)) {
            String filePath = value.substring(UNIX_DOMAIN_SOCKET_PREFIX.length());
            File file = new File(filePath);
            if (!file.isAbsolute()) {
                throw new IllegalArgumentException("Unix domain socket file path must be absolute, file: " + value);
            }
            return new DomainSocketAddress(file);
        }
        throw new IllegalArgumentException("Given address " + value + " is not a valid unix domain socket path");
    }
}

