/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.Metrics;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.request.HeadRequest;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.util.MetricKey;
import software.amazon.s3.analyticsaccelerator.util.OpenStreamInformation;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;
import software.amazon.s3.shaded.com.github.benmanes.caffeine.cache.Cache;
import software.amazon.s3.shaded.com.github.benmanes.caffeine.cache.Caffeine;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Inner class is created very infrequently, and fluency justifies the extra pointer")
public class MetadataStore
implements Closeable {
    private final ObjectClient objectClient;
    private final Telemetry telemetry;
    private final Cache<S3URI, ObjectMetadata> cache;
    private final PhysicalIOConfiguration configuration;
    private final Metrics aggregatingMetrics;
    private static final Logger LOG = LoggerFactory.getLogger(MetadataStore.class);
    private static final String OPERATION_METADATA_HEAD_ASYNC = "metadata.store.head.async";
    private static final String OPERATION_METADATA_HEAD_JOIN = "metadata.store.head.join";

    public MetadataStore(@NonNull ObjectClient objectClient, @NonNull Telemetry telemetry, @NonNull PhysicalIOConfiguration configuration, @NonNull Metrics aggregatingMetrics) {
        if (objectClient == null) {
            throw new NullPointerException("objectClient is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (aggregatingMetrics == null) {
            throw new NullPointerException("aggregatingMetrics is marked non-null but is null");
        }
        this.objectClient = objectClient;
        this.telemetry = telemetry;
        this.aggregatingMetrics = aggregatingMetrics;
        this.cache = Caffeine.newBuilder().expireAfterWrite(configuration.getMetadataCacheTtlMilliseconds(), TimeUnit.MILLISECONDS).maximumSize(configuration.getMetadataStoreCapacity()).build();
        this.configuration = configuration;
    }

    public ObjectMetadata get(S3URI s3URI, OpenStreamInformation openStreamInformation) throws IOException {
        return this.asyncGet(s3URI, openStreamInformation);
    }

    public boolean evictKey(S3URI s3URI) {
        ObjectMetadata removed = (ObjectMetadata)this.cache.asMap().remove(s3URI);
        return removed != null;
    }

    public synchronized ObjectMetadata asyncGet(S3URI s3URI, OpenStreamInformation openStreamInformation) {
        return this.cache.get(s3URI, (? super K uri) -> this.telemetry.measureCritical(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_METADATA_HEAD_ASYNC)).attribute(StreamAttributes.uri(s3URI))).build(), () -> {
            ObjectMetadata objectMetadata = this.objectClient.headObject(HeadRequest.builder().s3Uri(s3URI).build(), openStreamInformation);
            openStreamInformation.getRequestCallback().onHeadRequest();
            this.aggregatingMetrics.add(MetricKey.HEAD_REQUEST_COUNT, 1L);
            return objectMetadata;
        }));
    }

    public void storeObjectMetadata(S3URI s3URI, ObjectMetadata objectMetadata) {
        if (objectMetadata != null) {
            this.cache.put(s3URI, objectMetadata);
        }
    }

    @Override
    public void close() {
        this.cache.invalidateAll();
    }
}

