/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.source.JvmMetrics;

@Metrics(name="RouterActivity", about="Router metrics", context="dfs")
public class RouterMetrics {
    private final MetricsRegistry registry = new MetricsRegistry("router");
    @Metric(value={"Duration in SafeMode at startup in msec"})
    private MutableGaugeInt safeModeTime;
    private JvmMetrics jvmMetrics = null;

    RouterMetrics(String processName, String sessionId, JvmMetrics jvmMetrics) {
        this.jvmMetrics = jvmMetrics;
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, processName).tag((MetricsInfo)MsInfo.SessionId, sessionId);
    }

    public static RouterMetrics create(Configuration conf) {
        String sessionId = conf.get("dfs.metrics.session-id");
        String processName = "Router";
        MetricsSystem ms = DefaultMetricsSystem.instance();
        JvmMetrics jm = JvmMetrics.create((String)processName, (String)sessionId, (MetricsSystem)ms);
        return (RouterMetrics)ms.register((Object)new RouterMetrics(processName, sessionId, jm));
    }

    public JvmMetrics getJvmMetrics() {
        return this.jvmMetrics;
    }

    public void shutdown() {
        DefaultMetricsSystem.shutdown();
    }

    public void setSafeModeTime(long elapsed) {
        this.safeModeTime.set((int)elapsed);
    }
}

