/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.RequestOptions;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxClientCollectionCache;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Single;

public class PartitionKeyMismatchRetryPolicy
implements IDocumentClientRetryPolicy {
    private RxClientCollectionCache clientCollectionCache;
    private IDocumentClientRetryPolicy nextRetryPolicy;
    private AtomicInteger retriesAttempted = new AtomicInteger(0);
    private String collectionLink;
    private RequestOptions options;
    private static final int MaxRetries = 1;

    public PartitionKeyMismatchRetryPolicy(RxClientCollectionCache clientCollectionCache, IDocumentClientRetryPolicy nextRetryPolicy, String resourceFullName, RequestOptions requestOptions) {
        this.clientCollectionCache = clientCollectionCache;
        this.nextRetryPolicy = nextRetryPolicy;
        this.collectionLink = com.microsoft.azure.cosmosdb.internal.Utils.getCollectionName((String)resourceFullName);
        this.options = this.options;
    }

    @Override
    public Single<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception exception) {
        DocumentClientException clientException = (DocumentClientException)((Object)Utils.as((Object)exception, DocumentClientException.class));
        if (clientException != null && Exceptions.isStatusCode((DocumentClientException)clientException, (int)400) && Exceptions.isSubStatusCode((DocumentClientException)clientException, (int)1001) && this.retriesAttempted.get() < 1) {
            if (this.options != null) {
                this.clientCollectionCache.refresh(this.collectionLink, this.options.getProperties());
            } else {
                this.clientCollectionCache.refresh(this.collectionLink, null);
            }
            this.retriesAttempted.incrementAndGet();
            return Single.just((Object)IRetryPolicy.ShouldRetryResult.retryAfter(Duration.ZERO));
        }
        return this.nextRetryPolicy.shouldRetry(exception);
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.nextRetryPolicy.onBeforeSendRequest(request);
    }
}

