/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RouterFederationRename;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.TestRouterFederationRenameBase;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRouterFederationRename
extends TestRouterFederationRenameBase {
    private MiniRouterDFSCluster.RouterContext router;
    private FileSystem routerFS;
    private MiniRouterDFSCluster cluster;

    @BeforeClass
    public static void before() throws Exception {
        TestRouterFederationRename.globalSetUp();
    }

    @AfterClass
    public static void after() {
        TestRouterFederationRename.tearDown();
    }

    @Before
    public void testSetup() throws Exception {
        this.setup();
        this.router = this.getRouterContext();
        this.routerFS = this.getRouterFileSystem();
        this.cluster = this.getCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRenameDir(MiniRouterDFSCluster.RouterContext testRouter, String path, String renamedPath, boolean exceptionExpected, Callable<Object> call) throws IOException {
        this.createDir(testRouter.getFileSystem(), path);
        boolean exceptionThrown = false;
        try {
            call.call();
            Assert.assertFalse((boolean)FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), path));
            Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), renamedPath + "/file"));
        }
        catch (Exception ex) {
            exceptionThrown = true;
            Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), path + "/file"));
            Assert.assertFalse((boolean)FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), renamedPath));
        }
        finally {
            FileContext fileContext = testRouter.getFileContext();
            fileContext.delete(new Path(path), true);
            fileContext.delete(new Path(renamedPath), true);
        }
        if (exceptionExpected) {
            Assert.assertTrue((boolean)exceptionThrown);
        } else {
            Assert.assertFalse((boolean)exceptionThrown);
        }
    }

    @Test
    public void testSuccessfulRbfRename() throws Exception {
        List<String> nss = this.cluster.getNameservices();
        String ns0 = nss.get(0);
        String ns1 = nss.get(1);
        String dir = this.cluster.getFederatedTestDirectoryForNS(ns0) + "/" + GenericTestUtils.getMethodName();
        String renamedDir = this.cluster.getFederatedTestDirectoryForNS(ns1) + "/" + GenericTestUtils.getMethodName();
        this.testRenameDir(this.router, dir, renamedDir, false, () -> {
            DFSClient client = this.router.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename(dir, renamedDir);
            return null;
        });
        this.testRenameDir(this.router, dir, renamedDir, false, () -> {
            DFSClient client = this.router.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename2(dir, renamedDir, new Options.Rename[0]);
            return null;
        });
    }

    @Test
    public void testRbfRenameFile() throws Exception {
        List<String> nss = this.cluster.getNameservices();
        String ns0 = nss.get(0);
        String ns1 = nss.get(1);
        String file = this.cluster.getFederatedTestDirectoryForNS(ns0) + "/" + GenericTestUtils.getMethodName();
        String renamedFile = this.cluster.getFederatedTestDirectoryForNS(ns1) + "/" + GenericTestUtils.getMethodName();
        FederationTestUtils.createFile(this.routerFS, file, 32L);
        this.getRouterFileSystem().mkdirs(new Path(renamedFile));
        LambdaTestUtils.intercept(RemoteException.class, (String)"should be a directory", (String)"Expect RemoteException.", () -> {
            DFSClient client = this.router.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename(file, renamedFile);
            return null;
        });
        LambdaTestUtils.intercept(RemoteException.class, (String)"should be a directory", (String)"Expect RemoteException.", () -> {
            DFSClient client = this.router.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename2(file, renamedFile, new Options.Rename[0]);
            return null;
        });
        this.getRouterFileSystem().delete(new Path(file), true);
        this.getRouterFileSystem().delete(new Path(renamedFile), true);
    }

    @Test
    public void testRbfRenameWhenDstAlreadyExists() throws Exception {
        List<String> nss = this.cluster.getNameservices();
        String ns0 = nss.get(0);
        String ns1 = nss.get(1);
        String dir = this.cluster.getFederatedTestDirectoryForNS(ns0) + "/" + GenericTestUtils.getMethodName();
        String renamedDir = this.cluster.getFederatedTestDirectoryForNS(ns1) + "/" + GenericTestUtils.getMethodName();
        this.createDir(this.routerFS, dir);
        this.getRouterFileSystem().mkdirs(new Path(renamedDir));
        LambdaTestUtils.intercept(RemoteException.class, (String)"already exists", (String)"Expect RemoteException.", () -> {
            DFSClient client = this.router.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename(dir, renamedDir);
            return null;
        });
        LambdaTestUtils.intercept(RemoteException.class, (String)"already exists", (String)"Expect RemoteException.", () -> {
            DFSClient client = this.router.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename2(dir, renamedDir, new Options.Rename[0]);
            return null;
        });
        this.getRouterFileSystem().delete(new Path(dir), true);
        this.getRouterFileSystem().delete(new Path(renamedDir), true);
    }

    @Test
    public void testRbfRenameWhenSrcNotExists() throws Exception {
        List<String> nss = this.cluster.getNameservices();
        String ns0 = nss.get(0);
        String ns1 = nss.get(1);
        String dir = this.cluster.getFederatedTestDirectoryForNS(ns0) + "/" + GenericTestUtils.getMethodName();
        String renamedDir = this.cluster.getFederatedTestDirectoryForNS(ns1) + "/" + GenericTestUtils.getMethodName();
        LambdaTestUtils.intercept(RemoteException.class, (String)"File does not exist", (String)"Expect RemoteException.", () -> {
            DFSClient client = this.router.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename(dir, renamedDir);
            return null;
        });
        LambdaTestUtils.intercept(RemoteException.class, (String)"File does not exist", (String)"Expect RemoteException.", () -> {
            DFSClient client = this.router.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename2(dir, renamedDir, new Options.Rename[0]);
            return null;
        });
    }

    @Test
    public void testRbfRenameOfMountPoint() throws Exception {
        List<String> nss = this.cluster.getNameservices();
        String ns0 = nss.get(0);
        String ns1 = nss.get(1);
        String dir = this.cluster.getFederatedPathForNS(ns0);
        String renamedDir = this.cluster.getFederatedPathForNS(ns1);
        LambdaTestUtils.intercept(RemoteException.class, (String)"is a mount point", (String)"Expect RemoteException.", () -> {
            DFSClient client = this.router.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename(dir, renamedDir);
            return null;
        });
        LambdaTestUtils.intercept(RemoteException.class, (String)"is a mount point", (String)"Expect RemoteException.", () -> {
            DFSClient client = this.router.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename2(dir, renamedDir, new Options.Rename[0]);
            return null;
        });
    }

    @Test
    public void testRbfRenameWithMultiDestination() throws Exception {
        List<String> nss = this.cluster.getNameservices();
        String ns1 = nss.get(1);
        FileSystem rfs = this.getRouterFileSystem();
        String dir = "/same/" + GenericTestUtils.getMethodName();
        String renamedDir = this.cluster.getFederatedTestDirectoryForNS(ns1) + "/" + GenericTestUtils.getMethodName();
        this.createDir(rfs, dir);
        this.getRouterFileSystem().mkdirs(new Path(renamedDir));
        LambdaTestUtils.intercept(RemoteException.class, (String)"The remote location should be exactly one", (String)"Expect RemoteException.", () -> {
            DFSClient client = this.router.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename(dir, renamedDir);
            return null;
        });
        LambdaTestUtils.intercept(RemoteException.class, (String)"The remote location should be exactly one", (String)"Expect RemoteException.", () -> {
            DFSClient client = this.router.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename2(dir, renamedDir, new Options.Rename[0]);
            return null;
        });
        this.getRouterFileSystem().delete(new Path(dir), true);
        this.getRouterFileSystem().delete(new Path(renamedDir), true);
    }

    @Test(timeout=20000L)
    public void testCounter() throws Exception {
        RouterRpcServer rpcServer = this.router.getRouter().getRpcServer();
        List<String> nss = this.cluster.getNameservices();
        String ns0 = nss.get(0);
        String ns1 = nss.get(1);
        RouterFederationRename rbfRename = (RouterFederationRename)Mockito.spy((Object)new RouterFederationRename(rpcServer, this.router.getConf()));
        String path = "/src";
        this.createDir((FileSystem)this.cluster.getCluster().getFileSystem(0), path);
        int expectedSchedulerCount = rpcServer.getSchedulerJobCount() + 1;
        AtomicInteger maxSchedulerCount = new AtomicInteger();
        AtomicBoolean watch = new AtomicBoolean(true);
        Thread watcher = new Thread(() -> {
            while (watch.get()) {
                int schedulerCount = rpcServer.getSchedulerJobCount();
                if (schedulerCount > maxSchedulerCount.get()) {
                    maxSchedulerCount.set(schedulerCount);
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        watcher.start();
        rbfRename.routerFedRename("/src", "/dst", Arrays.asList(new RemoteLocation(ns0, path, null)), Arrays.asList(new RemoteLocation(ns1, path, null)));
        ((RouterFederationRename)Mockito.verify((Object)rbfRename)).countIncrement();
        ((RouterFederationRename)Mockito.verify((Object)rbfRename)).countDecrement();
        watch.set(false);
        watcher.interrupt();
        watcher.join();
        Assert.assertEquals((long)expectedSchedulerCount, (long)maxSchedulerCount.get());
        Assert.assertFalse((boolean)this.cluster.getCluster().getFileSystem(0).exists(new Path(path)));
        Assert.assertTrue((boolean)this.cluster.getCluster().getFileSystem(1).delete(new Path(path), true));
    }

    public static class MockGroupsMapping
    implements GroupMappingServiceProvider {
        public List<String> getGroups(String user) {
            return Arrays.asList(user + "_group");
        }

        public void cacheGroupsRefresh() {
        }

        public void cacheGroupsAdd(List<String> groups) {
        }

        public Set<String> getGroupsSet(String user) {
            return ImmutableSet.of((Object)(user + "_group"));
        }
    }
}

