/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.logical.parquet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.shaded.apache.parquet.format.FileMetaData;
import software.amazon.s3.shaded.apache.parquet.format.InterningProtocol;
import software.amazon.s3.shaded.parquet.org.apache.thrift.TException;
import software.amazon.s3.shaded.parquet.org.apache.thrift.protocol.TCompactProtocol;
import software.amazon.s3.shaded.parquet.org.apache.thrift.protocol.TProtocol;
import software.amazon.s3.shaded.parquet.org.apache.thrift.transport.TIOStreamTransport;
import software.amazon.s3.shaded.parquet.org.apache.thrift.transport.TTransportException;

class ParquetParser {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetParser.class);

    ParquetParser() {
    }

    public FileMetaData parseParquetFooter(ByteBuffer fileTail, int contentLen, S3URI s3URI) throws IOException {
        Preconditions.checkArgument(contentLen > 8, "Specified content length is too low");
        int fileMetadataLengthIndex = contentLen - 4 - 4;
        fileTail.position(fileMetadataLengthIndex);
        byte[] buff = new byte[4];
        fileTail.get(buff, 0, 4);
        int fileMetadataLength = ParquetParser.readIntLittleEndian(new ByteArrayInputStream(buff));
        int fileMetadataIndex = fileMetadataLengthIndex - fileMetadataLength;
        if (fileMetadataIndex < 0) {
            LOG.debug("Insufficient data in cached footer for {}. Required length  is {}, provided length of data is {}. Parquet optimisations will be turned off for this file. To prevent this, increase cached length using footer.caching.size", new Object[]{s3URI.getKey(), fileMetadataLength, contentLen});
            throw new IOException("Insufficient data in cached footer for " + s3URI.getKey() + ". Required length  is " + fileMetadataLength + ", provided length of data is " + contentLen);
        }
        fileTail.position(fileMetadataIndex);
        byte[] footer = new byte[fileMetadataLength];
        fileTail.get(footer, 0, fileMetadataLength);
        try {
            FileMetaData fmd = new FileMetaData();
            fmd.read(ParquetParser.protocol(new ByteArrayInputStream(footer)));
            return fmd;
        }
        catch (TException e) {
            throw new IOException("can not read FileMetaData: " + e.getMessage(), e);
        }
    }

    private static TProtocol protocol(InputStream from) throws TTransportException {
        return ParquetParser.protocol(new TIOStreamTransport(from));
    }

    private static InterningProtocol protocol(TIOStreamTransport t) {
        return new InterningProtocol(new TCompactProtocol(t));
    }

    private static int readIntLittleEndian(InputStream in) throws IOException {
        int ch1 = in.read();
        int ch2 = in.read();
        int ch3 = in.read();
        int ch4 = in.read();
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }
}

