/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.Metrics;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIOConfiguration;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlobStoreIndexCache;
import software.amazon.s3.analyticsaccelerator.io.physical.data.Block;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlockStore;
import software.amazon.s3.analyticsaccelerator.io.physical.data.IOPlanner;
import software.amazon.s3.analyticsaccelerator.io.physical.data.RangeOptimiser;
import software.amazon.s3.analyticsaccelerator.io.physical.prefetcher.SequentialPatternDetector;
import software.amazon.s3.analyticsaccelerator.io.physical.prefetcher.SequentialReadProgression;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.request.ReadMode;
import software.amazon.s3.analyticsaccelerator.util.AnalyticsAcceleratorUtils;
import software.amazon.s3.analyticsaccelerator.util.BlockKey;
import software.amazon.s3.analyticsaccelerator.util.ObjectKey;
import software.amazon.s3.analyticsaccelerator.util.OpenStreamInformation;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class BlockManager
implements Closeable {
    private final ObjectKey objectKey;
    private final ObjectMetadata metadata;
    private final BlockStore blockStore;
    private final ObjectClient objectClient;
    private final Telemetry telemetry;
    private final SequentialPatternDetector patternDetector;
    private final SequentialReadProgression sequentialReadProgression;
    private final IOPlanner ioPlanner;
    private final PhysicalIOConfiguration configuration;
    private final RangeOptimiser rangeOptimiser;
    private OpenStreamInformation openStreamInformation;
    private final Metrics aggregatingMetrics;
    private final BlobStoreIndexCache indexCache;
    private static final String OPERATION_MAKE_RANGE_AVAILABLE = "block.manager.make.range.available";
    private static final Logger LOG = LoggerFactory.getLogger(BlockManager.class);

    public BlockManager(@NonNull ObjectKey objectKey, @NonNull ObjectClient objectClient, @NonNull ObjectMetadata metadata, @NonNull Telemetry telemetry, @NonNull PhysicalIOConfiguration configuration, @NonNull Metrics aggregatingMetrics, @NonNull BlobStoreIndexCache indexCache, @NonNull OpenStreamInformation openStreamInformation) {
        if (objectKey == null) {
            throw new NullPointerException("objectKey is marked non-null but is null");
        }
        if (objectClient == null) {
            throw new NullPointerException("objectClient is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (aggregatingMetrics == null) {
            throw new NullPointerException("aggregatingMetrics is marked non-null but is null");
        }
        if (indexCache == null) {
            throw new NullPointerException("indexCache is marked non-null but is null");
        }
        if (openStreamInformation == null) {
            throw new NullPointerException("openStreamInformation is marked non-null but is null");
        }
        this.objectKey = objectKey;
        this.objectClient = objectClient;
        this.metadata = metadata;
        this.telemetry = telemetry;
        this.configuration = configuration;
        this.aggregatingMetrics = aggregatingMetrics;
        this.indexCache = indexCache;
        this.blockStore = new BlockStore(objectKey, metadata, aggregatingMetrics, indexCache);
        this.patternDetector = new SequentialPatternDetector(this.blockStore);
        this.sequentialReadProgression = new SequentialReadProgression(configuration);
        this.ioPlanner = new IOPlanner(this.blockStore);
        this.rangeOptimiser = new RangeOptimiser(configuration);
        this.openStreamInformation = openStreamInformation;
        this.prefetchSmallObject();
    }

    private void prefetchSmallObject() {
        if (AnalyticsAcceleratorUtils.isSmallObject(this.configuration, this.metadata.getContentLength())) {
            try {
                this.makeRangeAvailable(0L, this.metadata.getContentLength(), ReadMode.SMALL_OBJECT_PREFETCH);
            }
            catch (IOException e) {
                LOG.debug("Failed to prefetch small object for key: {}", (Object)this.objectKey.getS3URI().getKey(), (Object)e);
            }
        }
    }

    public boolean isBlockStoreEmpty() {
        return this.blockStore.isBlockStoreEmpty();
    }

    public synchronized Optional<Block> getBlock(long pos) {
        return this.blockStore.getBlock(pos);
    }

    public synchronized void makePositionAvailable(long pos, ReadMode readMode) throws IOException {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        if (this.getBlock(pos).isPresent()) {
            return;
        }
        this.makeRangeAvailable(pos, 1L, readMode);
    }

    private boolean isRangeAvailable(long pos, long len) throws IOException {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(0L <= len, "`len` must not be negative");
        long lastByteOfRange = pos + len - 1L;
        OptionalLong nextMissingByte = this.blockStore.findNextMissingByte(pos);
        if (nextMissingByte.isPresent()) {
            return lastByteOfRange < nextMissingByte.getAsLong();
        }
        return true;
    }

    public synchronized void makeRangeAvailable(long pos, long len, ReadMode readMode) throws IOException {
        long generation;
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(0L <= len, "`len` must not be negative");
        if (this.isRangeAvailable(pos, len)) {
            return;
        }
        long effectiveEnd = pos + Math.max(len, this.configuration.getReadAheadBytes()) - 1L;
        if (readMode.allowRequestExtension() && this.patternDetector.isSequentialRead(pos)) {
            generation = this.patternDetector.getGeneration(pos);
            effectiveEnd = Math.max(effectiveEnd, this.truncatePos(pos + this.sequentialReadProgression.getSizeForGeneration(generation)));
        } else {
            generation = 0L;
        }
        long effectiveEndFinal = effectiveEnd;
        this.telemetry.measureStandard(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_MAKE_RANGE_AVAILABLE)).attribute(StreamAttributes.uri(this.objectKey.getS3URI()))).attribute(StreamAttributes.etag(this.objectKey.getEtag()))).attribute(StreamAttributes.range(pos, pos + len - 1L))).attribute(StreamAttributes.effectiveRange(pos, effectiveEndFinal))).attribute(StreamAttributes.generation(generation))).build(), () -> {
            List<Range> missingRanges = this.ioPlanner.planRead(pos, effectiveEndFinal, this.getLastObjectByte());
            List<Range> splits = this.rangeOptimiser.splitRanges(missingRanges);
            for (Range r : splits) {
                BlockKey blockKey = new BlockKey(this.objectKey, r);
                Block block = new Block(blockKey, this.objectClient, this.telemetry, generation, readMode, this.configuration.getBlockReadTimeout(), this.configuration.getBlockReadRetryCount(), this.aggregatingMetrics, this.indexCache, this.openStreamInformation);
                this.blockStore.add(blockKey, block);
            }
        });
    }

    public void cleanUp() {
        this.blockStore.cleanUp();
    }

    private long getLastObjectByte() {
        return this.metadata.getContentLength() - 1L;
    }

    private long truncatePos(long pos) {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        return Math.min(pos, this.getLastObjectByte());
    }

    @Override
    public void close() {
        this.blockStore.close();
    }
}

