/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs;

import org.apache.hadoop.oncrpc.XDR;

public class NfsTime {
    static final int MILLISECONDS_IN_SECOND = 1000;
    static final int NANOSECONDS_IN_MILLISECOND = 1000000;
    private final int seconds;
    private final int nseconds;

    public NfsTime(int seconds, int nseconds) {
        this.seconds = seconds;
        this.nseconds = nseconds;
    }

    public NfsTime(NfsTime other) {
        this.seconds = other.getNseconds();
        this.nseconds = other.getNseconds();
    }

    public NfsTime(long milliseconds) {
        this.seconds = (int)(milliseconds / 1000L);
        this.nseconds = (int)((milliseconds - (long)(this.seconds * 1000)) * 1000000L);
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getNseconds() {
        return this.nseconds;
    }

    public long getMilliSeconds() {
        return (long)this.seconds * 1000L + (long)this.nseconds / 1000000L;
    }

    public void serialize(XDR xdr) {
        xdr.writeInt(this.getSeconds());
        xdr.writeInt(this.getNseconds());
    }

    public static NfsTime deserialize(XDR xdr) {
        return new NfsTime(xdr.readInt(), xdr.readInt());
    }

    public int hashCode() {
        return this.seconds ^ this.nseconds;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NfsTime)) {
            return false;
        }
        return ((NfsTime)o).getMilliSeconds() == this.getMilliSeconds();
    }

    public String toString() {
        return "(NfsTime-" + this.seconds + "s, " + this.nseconds + "ns)";
    }
}

