/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.protocol.OutlierMetrics;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSlowDatanodeReport {
    private static final Logger LOG = LoggerFactory.getLogger(TestSlowDatanodeReport.class);
    private MiniDFSCluster cluster;

    @Before
    public void testSetup() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.datanode.outliers.report.interval", "1000");
        conf.set("dfs.datanode.peer.stats.enabled", "true");
        conf.set("dfs.datanode.min.outlier.detection.nodes", "1");
        conf.set("dfs.datanode.peer.metrics.min.outlier.detection.samples", "1");
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        this.cluster.waitActive();
    }

    @After
    public void tearDown() throws Exception {
        this.cluster.shutdown();
    }

    @Test
    public void testSingleNodeReport() throws Exception {
        ArrayList<DataNode> dataNodes = this.cluster.getDataNodes();
        DataNode slowNode = (DataNode)dataNodes.get(1);
        OutlierMetrics outlierMetrics = new OutlierMetrics(Double.valueOf(1.245), Double.valueOf(2.69375), Double.valueOf(4.5667), Double.valueOf(15.5));
        ((DataNode)dataNodes.get(0)).getPeerMetrics().setTestOutliers((Map)ImmutableMap.of((Object)(slowNode.getDatanodeHostname() + ":" + slowNode.getIpcPort()), (Object)outlierMetrics));
        DistributedFileSystem distributedFileSystem = this.cluster.getFileSystem();
        Assert.assertEquals((long)3L, (long)distributedFileSystem.getDataNodeStats().length);
        GenericTestUtils.waitFor(() -> {
            try {
                DatanodeInfo[] slowNodeInfo = distributedFileSystem.getSlowDatanodeStats();
                LOG.info("Slow Datanode report: {}", Arrays.asList(slowNodeInfo));
                return slowNodeInfo.length == 1;
            }
            catch (IOException e) {
                LOG.error("Failed to retrieve slownode report", (Throwable)e);
                return false;
            }
        }, (long)2000L, (long)180000L, (String)"Slow nodes could not be detected");
        LOG.info("Slow peer report: {}", (Object)this.cluster.getNameNode().getSlowPeersReport());
        Assert.assertTrue((this.cluster.getNameNode().getSlowPeersReport().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.cluster.getNameNode().getSlowPeersReport().contains(slowNode.getDatanodeHostname()));
        Assert.assertTrue((boolean)this.cluster.getNameNode().getSlowPeersReport().contains("15.5"));
        Assert.assertTrue((boolean)this.cluster.getNameNode().getSlowPeersReport().contains("1.245"));
        Assert.assertTrue((boolean)this.cluster.getNameNode().getSlowPeersReport().contains("2.69375"));
        Assert.assertTrue((boolean)this.cluster.getNameNode().getSlowPeersReport().contains("4.5667"));
    }

    @Test
    public void testMultiNodesReport() throws Exception {
        ArrayList<DataNode> dataNodes = this.cluster.getDataNodes();
        OutlierMetrics outlierMetrics1 = new OutlierMetrics(Double.valueOf(2.498237), Double.valueOf(19.2495), Double.valueOf(23.568204), Double.valueOf(14.5));
        OutlierMetrics outlierMetrics2 = new OutlierMetrics(Double.valueOf(3.2535), Double.valueOf(22.4945), Double.valueOf(44.5667), Double.valueOf(18.7));
        ((DataNode)dataNodes.get(0)).getPeerMetrics().setTestOutliers((Map)ImmutableMap.of((Object)(((DataNode)dataNodes.get(1)).getDatanodeHostname() + ":" + ((DataNode)dataNodes.get(1)).getIpcPort()), (Object)outlierMetrics1));
        ((DataNode)dataNodes.get(1)).getPeerMetrics().setTestOutliers((Map)ImmutableMap.of((Object)(((DataNode)dataNodes.get(2)).getDatanodeHostname() + ":" + ((DataNode)dataNodes.get(2)).getIpcPort()), (Object)outlierMetrics2));
        DistributedFileSystem distributedFileSystem = this.cluster.getFileSystem();
        Assert.assertEquals((long)3L, (long)distributedFileSystem.getDataNodeStats().length);
        GenericTestUtils.waitFor(() -> {
            try {
                DatanodeInfo[] slowNodeInfo = distributedFileSystem.getSlowDatanodeStats();
                LOG.info("Slow Datanode report: {}", Arrays.asList(slowNodeInfo));
                return slowNodeInfo.length == 2;
            }
            catch (IOException e) {
                LOG.error("Failed to retrieve slownode report", (Throwable)e);
                return false;
            }
        }, (long)2000L, (long)200000L, (String)"Slow nodes could not be detected");
        LOG.info("Slow peer report: {}", (Object)this.cluster.getNameNode().getSlowPeersReport());
        Assert.assertTrue((this.cluster.getNameNode().getSlowPeersReport().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.cluster.getNameNode().getSlowPeersReport().contains(((DataNode)dataNodes.get(1)).getDatanodeHostname()));
        Assert.assertTrue((boolean)this.cluster.getNameNode().getSlowPeersReport().contains(((DataNode)dataNodes.get(2)).getDatanodeHostname()));
        Assert.assertTrue((boolean)this.cluster.getNameNode().getSlowPeersReport().contains("14.5"));
        Assert.assertTrue((boolean)this.cluster.getNameNode().getSlowPeersReport().contains("18.7"));
        Assert.assertTrue((boolean)this.cluster.getNameNode().getSlowPeersReport().contains("23.568204"));
        Assert.assertTrue((boolean)this.cluster.getNameNode().getSlowPeersReport().contains("22.4945"));
    }
}

