/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.InvalidBlockReportLeaseException;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.RegisterCommand;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestBlockReportLease {
    @Test
    public void testCheckBlockReportLease() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        Random rand = new Random();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();){
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNamesystem();
            BlockManager blockManager = fsn.getBlockManager();
            BlockManager spyBlockManager = (BlockManager)Mockito.spy((Object)blockManager);
            fsn.setBlockManagerForTesting(spyBlockManager);
            String poolId = cluster.getNamesystem().getBlockPoolId();
            NamenodeProtocols rpcServer = cluster.getNameNodeRpc();
            DataNode dn = cluster.getDataNodes().get(0);
            DatanodeDescriptor datanodeDescriptor = spyBlockManager.getDatanodeManager().getDatanode(dn.getDatanodeId());
            DatanodeRegistration dnRegistration = dn.getDNRegistrationForBP(poolId);
            StorageReport[] storages = dn.getFSDataset().getStorageReports(poolId);
            HeartbeatResponse hbResponse = rpcServer.sendHeartbeat(dnRegistration, storages, 0L, 0L, 0, 0, 0, null, true, SlowPeerReports.EMPTY_REPORT, SlowDiskReports.EMPTY_REPORT);
            GenericTestUtils.DelayAnswer delayer = new GenericTestUtils.DelayAnswer(BlockManager.LOG);
            ((BlockManager)Mockito.doAnswer((Answer)delayer).when((Object)spyBlockManager)).processReport((DatanodeStorageInfo)ArgumentMatchers.any(DatanodeStorageInfo.class), (BlockListAsLongs)ArgumentMatchers.any(BlockListAsLongs.class));
            ExecutorService pool = Executors.newFixedThreadPool(1);
            BlockReportContext brContext = new BlockReportContext(1, 0, rand.nextLong(), hbResponse.getFullBlockReportLeaseId());
            Future<DatanodeCommand> sendBRfuturea = pool.submit(() -> {
                DatanodeStorage[] datanodeStorages = new DatanodeStorage[storages.length];
                for (int i = 0; i < storages.length; ++i) {
                    datanodeStorages[i] = storages[i].getStorage();
                }
                StorageBlockReport[] reports = this.createReports(datanodeStorages, 100);
                return rpcServer.blockReport(dnRegistration, poolId, reports, brContext);
            });
            delayer.waitForCall();
            spyBlockManager.getBlockReportLeaseManager().removeLease(datanodeDescriptor);
            delayer.proceed();
            DatanodeCommand datanodeCommand = sendBRfuturea.get();
            Assert.assertTrue((boolean)(datanodeCommand instanceof FinalizeCommand));
            Assert.assertEquals((Object)poolId, (Object)((FinalizeCommand)datanodeCommand).getBlockPoolId());
        }
    }

    @Test
    public void testExceptionThrownWhenFBRLeaseExpired() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        Random rand = new Random();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();){
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNamesystem();
            BlockManager blockManager = fsn.getBlockManager();
            BlockManager spyBlockManager = (BlockManager)Mockito.spy((Object)blockManager);
            fsn.setBlockManagerForTesting(spyBlockManager);
            String poolId = cluster.getNamesystem().getBlockPoolId();
            NamenodeProtocols rpcServer = cluster.getNameNodeRpc();
            DataNode dn = cluster.getDataNodes().get(0);
            DatanodeDescriptor datanodeDescriptor = spyBlockManager.getDatanodeManager().getDatanode(dn.getDatanodeId());
            DatanodeRegistration dnRegistration = dn.getDNRegistrationForBP(poolId);
            StorageReport[] storages = dn.getFSDataset().getStorageReports(poolId);
            HeartbeatResponse hbResponse = rpcServer.sendHeartbeat(dnRegistration, storages, 0L, 0L, 0, 0, 0, null, true, SlowPeerReports.EMPTY_REPORT, SlowDiskReports.EMPTY_REPORT);
            spyBlockManager.getBlockReportLeaseManager().removeLease(datanodeDescriptor);
            ExecutorService pool = Executors.newFixedThreadPool(1);
            BlockReportContext brContext = new BlockReportContext(1, 0, rand.nextLong(), hbResponse.getFullBlockReportLeaseId());
            Future<DatanodeCommand> sendBRfuturea = pool.submit(() -> {
                DatanodeStorage[] datanodeStorages = new DatanodeStorage[storages.length];
                for (int i = 0; i < storages.length; ++i) {
                    datanodeStorages[i] = storages[i].getStorage();
                }
                StorageBlockReport[] reports = this.createReports(datanodeStorages, 100);
                return rpcServer.blockReport(dnRegistration, poolId, reports, brContext);
            });
            ExecutionException exception = null;
            try {
                sendBRfuturea.get();
            }
            catch (ExecutionException e) {
                exception = e;
            }
            Assertions.assertNotNull((Object)exception);
            Assert.assertEquals(InvalidBlockReportLeaseException.class, exception.getCause().getClass());
        }
    }

    @Test
    public void testCheckBlockReportLeaseWhenDnUnregister() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        Random rand = new Random();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();){
            FSNamesystem fsn = cluster.getNamesystem();
            BlockManager blockManager = fsn.getBlockManager();
            String poolId = cluster.getNamesystem().getBlockPoolId();
            NamenodeProtocols rpcServer = cluster.getNameNodeRpc();
            DataNode dn = cluster.getDataNodes().get(0);
            blockManager.getDatanodeManager().getDatanodeMap().remove(dn.getDatanodeUuid());
            DatanodeRegistration dnRegistration = dn.getDNRegistrationForBP(poolId);
            StorageReport[] storages = dn.getFSDataset().getStorageReports(poolId);
            ExecutorService pool = Executors.newFixedThreadPool(1);
            BlockReportContext brContext = new BlockReportContext(1, 0, rand.nextLong(), 1L);
            Future<DatanodeCommand> sendBRFuture = pool.submit(() -> {
                DatanodeStorage[] datanodeStorages = new DatanodeStorage[storages.length];
                for (int i = 0; i < storages.length; ++i) {
                    datanodeStorages[i] = storages[i].getStorage();
                }
                StorageBlockReport[] reports = this.createReports(datanodeStorages, 100);
                return rpcServer.blockReport(dnRegistration, poolId, reports, brContext);
            });
            DatanodeCommand datanodeCommand = sendBRFuture.get();
            Assert.assertTrue((boolean)(datanodeCommand instanceof RegisterCommand));
        }
    }

    private StorageBlockReport[] createReports(DatanodeStorage[] dnStorages, int numBlocks) {
        int longsPerBlock = 3;
        int blockListSize = 2 + numBlocks * longsPerBlock;
        int numStorages = dnStorages.length;
        StorageBlockReport[] storageBlockReports = new StorageBlockReport[numStorages];
        for (int i = 0; i < numStorages; ++i) {
            ArrayList<Long> longs = new ArrayList<Long>(blockListSize);
            longs.add(Long.valueOf(numBlocks));
            longs.add(0L);
            for (int j = 0; j < blockListSize; ++j) {
                longs.add(Long.valueOf(j));
            }
            BlockListAsLongs blockList = BlockListAsLongs.decodeLongs(longs);
            storageBlockReports[i] = new StorageBlockReport(dnStorages[i], blockList);
        }
        return storageBlockReports;
    }

    @Test(timeout=360000L)
    public void testFirstIncompleteBlockReport() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        Random rand = new Random();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();){
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNamesystem();
            NameNode nameNode = cluster.getNameNode();
            NameNodeAdapter.enterSafeMode(nameNode, false);
            BlockManager blockManager = fsn.getBlockManager();
            BlockManager spyBlockManager = (BlockManager)Mockito.spy((Object)blockManager);
            fsn.setBlockManagerForTesting(spyBlockManager);
            String poolId = cluster.getNamesystem().getBlockPoolId();
            NamenodeProtocols rpcServer = cluster.getNameNodeRpc();
            DataNode dn = cluster.getDataNodes().get(0);
            DatanodeDescriptor datanodeDescriptor = spyBlockManager.getDatanodeManager().getDatanode(dn.getDatanodeId());
            DatanodeRegistration dnRegistration = dn.getDNRegistrationForBP(poolId);
            StorageReport[] storages = dn.getFSDataset().getStorageReports(poolId);
            HeartbeatResponse hbResponse = rpcServer.sendHeartbeat(dnRegistration, storages, 0L, 0L, 0, 0, 0, null, true, SlowPeerReports.EMPTY_REPORT, SlowDiskReports.EMPTY_REPORT);
            GenericTestUtils.DelayAnswer delayer = new GenericTestUtils.DelayAnswer(BlockManager.LOG);
            ((BlockManager)Mockito.doAnswer((Answer)delayer).when((Object)spyBlockManager)).processReport((DatanodeStorageInfo)ArgumentMatchers.any(DatanodeStorageInfo.class), (BlockListAsLongs)ArgumentMatchers.any(BlockListAsLongs.class));
            BlockReportContext brContext = new BlockReportContext(1, 0, rand.nextLong(), hbResponse.getFullBlockReportLeaseId());
            DatanodeStorage[] datanodeStorages = new DatanodeStorage[storages.length];
            for (int i = 0; i < storages.length; ++i) {
                datanodeStorages[i] = storages[i].getStorage();
                StorageBlockReport[] reports = this.createReports(datanodeStorages, 100);
                if (i == 0) {
                    rpcServer.blockReport(dnRegistration, poolId, reports, brContext);
                }
                DatanodeCommand datanodeCommand = rpcServer.blockReport(dnRegistration, poolId, reports, brContext);
                delayer.waitForCall();
                delayer.proceed();
                Assert.assertTrue((boolean)(datanodeCommand instanceof FinalizeCommand));
                Assert.assertEquals((Object)poolId, (Object)((FinalizeCommand)datanodeCommand).getBlockPoolId());
                if (i == 0) {
                    Assert.assertEquals((long)2L, (long)datanodeDescriptor.getStorageInfos()[i].getBlockReportCount());
                    continue;
                }
                Assert.assertEquals((long)1L, (long)datanodeDescriptor.getStorageInfos()[i].getBlockReportCount());
            }
        }
    }
}

